<?php
if ( ! defined( 'ABSPATH' ) ) exit;

/*
Plugin Name: Senthor – Protect Against AI Crawlers
Description: Detect, block or monetize AI bots. Protect your content and get paid.
Version: 1.1.1
Author: Senthor
License: GPLv2
*/
global $wp;

require_once plugin_dir_path(__FILE__) . 'consent.php';
require_once plugin_dir_path(__FILE__) . 'request.php';
require_once plugin_dir_path(__FILE__) . 'show_badge.php';

// Redirect to consent screen on activation
register_activation_hook(__FILE__, function() {
    add_option('senthor_show_consent_screen', true);
});
register_deactivation_hook(__FILE__, function() {
    delete_option('senthor_api_consent');
    delete_option('senthor_show_badge');
});

add_action("wp", "validate_request", 1);

// Redirect user after activation
add_action('admin_init', function() {
    if (get_option('senthor_show_consent_screen', false)) {
        delete_option('senthor_show_consent_screen');
        wp_safe_redirect(admin_url('admin.php?page=senthor-consent'));
        exit;
    }

    // Ensure the badge option exists (default to true)
    if (get_option('senthor_show_badge') === false) {
        add_option('senthor_show_badge', false);
    }
});

// Add a hidden admin page for consent ===
add_action('admin_menu', function() {
    add_menu_page(
        'Senthor Consent',
        'Senthor.io',
        'manage_options',
        'senthor-consent',
        'senthor_render_consent_screen',
        'dashicons-shield-alt',
        65
    );
});