<?php
if ( ! defined( 'ABSPATH' ) ) exit;

function senthor_can_operate() {
    return (bool) get_option('senthor_api_consent', false);
}

// Consent screen HTML
function senthor_render_consent_screen() {
    // Handle form submission
    if (isset($_SERVER['REQUEST_METHOD']) && $_SERVER['REQUEST_METHOD'] === 'POST' && check_admin_referer('senthor_consent_action', 'senthor_consent_nonce')) {

        // Consent form submission
        if (isset($_POST['senthor_action'])) {
            if ($_POST['senthor_action'] === 'accept') {
                update_option('senthor_api_consent', true);
            } elseif ($_POST['senthor_action'] === 'revoke') {
                delete_option('senthor_api_consent');
            }
        }

        // Badge settings form submission
        if (isset($_POST['senthor_save_settings'])) {
            $badge = !empty($_POST['senthor_show_badge']) ? true : false;
            update_option('senthor_show_badge', $badge);
            echo '<div class="updated notice"><p>✅ Settings saved.</p></div>';
        }
    }

    $consented = get_option('senthor_api_consent', false);
    $show_badge = get_option('senthor_show_badge', true);
    ?>
    <div class="wrap" style="max-width:800px;">
        <h1>Senthor for WordPress</h1>

        <?php if ($consented) : ?>
            <div class="updated notice"><p>✅ Consent granted — the plugin is active and communicating with the Senthor API.</p></div>
        <?php else : ?>
            <div class="notice notice-warning"><p>⚠️ Consent revoked. Senthor API connection disabled.</p></div>
        <?php endif; ?>

        <!-- Intro -->
        <div style="margin-bottom:20px;">
            <p>Generative AIs (ChatGPT, Perplexity, Mistral, etc.) are scraping millions of articles every day, without authorization, control, or revenue for publishers. <strong>Senthor for WordPress</strong> allows you to take back control</p>
            <p>This plugin connects your WordPress site to your Senthor account. Once activated, your content is monitored and protected in the background without modifying your site.</p>
        </div>

        <!-- Installation -->
        <h2>Installation</h2>
        <ol>
            <li>Consent to Senthor data usage below</li>
            <li>Go to <a href="https://www.senthor.io" target="_blank">Senthor.io</a> and create a free account.</li>
            <li>Add your domain (e.g. <code>www.yoursite.com</code>) in your Senthor dashboard.</li>
            <li>Check the <strong>“WordPress site”</strong> option for that domain.</li>
            <li>Stats and protections will start working immediately.</li>
        </ol>

        <h2>Data usage</h2>

        <div style="background:#fff;padding:0 16px;border:1px solid #ddd;margin-top:20px;">
            <p>This plugin detects and blocks AI by analyzing incoming visitor requests via the Senthor API.</p>
            <p>The following data may be transmitted to our API:</p>
            <ul style="list-style:disc;margin-left:20px;">
                <li>IP address</li>
                <li>HTTP headers</li>
                <li>Request URI</li>
            </ul>
            <p>This data is used <strong>only</strong> for AI detection and is not shared with third parties.</p>
        </div>

        <!-- Consent / Revoke Form -->
        <form method="post" style="margin-top:30px;">
            <?php wp_nonce_field('senthor_consent_action', 'senthor_consent_nonce'); ?>

            <?php if ($consented) : ?>
                <input type="hidden" name="senthor_action" value="revoke">
                <?php submit_button('Revoke Consent and Disable API', 'delete'); ?>

            <?php else : ?>
                <p>
                    <label>
                        <input type="checkbox" name="agree" required> 
                        I have read and agree to send visitor request headers to the Senthor API for AI detection.
                    </label>
                </p>
                <input type="hidden" name="senthor_action" value="accept">
                <?php submit_button('I Agree and Activate'); ?>
            <?php endif; ?>
        </form>

        <h2 style="margin-top:40px;">Settings</h2>
        <form method="post">
            <?php wp_nonce_field('senthor_consent_action', 'senthor_consent_nonce'); ?>

            <p>
                <label>
                    <input type="checkbox" name="senthor_show_badge" value="1" <?php checked($show_badge, true); ?>>
                    Display "Protected by Senthor" badge on all pages
                </label>
            </p>

            <input type="hidden" name="senthor_save_settings" value="1">
            <?php submit_button('Save Settings'); ?>
        </form>
    </div>
    <?php
}
?>