# Sengeku Meta Description Manager

A lightweight WordPress plugin for managing meta descriptions with an elegant interface and character counter.

## Features

- Elegant meta box in the editor sidebar
- Real-time character counter with visual warning (max 160 characters)
- Live preview of the meta description
- Overview column in the posts/pages list
- Quick Edit function for fast adjustments
- Support for all public post types (Posts, Pages, Custom Post Types)
- No configuration required - just activate and start using

## Requirements

- WordPress 5.0 or higher
- PHP 7.4 or higher

## Installation

1. Upload the plugin folder to `/wp-content/plugins/sengeku-meta-description-manager/`
2. Activate the plugin through the "Plugins" menu in WordPress
3. Edit any post or page to see the Meta Description box in the sidebar

## Development Notes

### WordPress.org Submission (Version 1.2.0)

This version includes all fixes required for WordPress.org submission:

- **English translations**: All UI strings, comments, and documentation in English
- **Proper asset enqueueing**: CSS/JS via `wp_add_inline_style()` and `wp_add_inline_script()`
- **Version parameters**: Explicit version strings for cache busting
- **Correct text domain**: `sengeku-meta-description-manager` (matching plugin slug)
- **Updated compatibility**: Tested up to WordPress 6.9

### Key Files

| File | Purpose |
|------|---------|
| `sengeku-meta-description.php` | Main plugin file |
| `readme.txt` | WordPress.org plugin description |
| `languages/` | Translation files (prepared) |

### Security Measures

- Nonce verification for all form submissions
- Input sanitization with `sanitize_textarea_field()`
- Output escaping with `esc_html()`, `esc_attr()`, `esc_textarea()`
- Capability checks with `current_user_can()`
- ABSPATH security check

## License

GPL v2 or later

## Author

Sen-ge-ku - https://sen-ge-ku.de
