<?php
/**
 * Template for displaying the prayer submission form
 * This can be used for custom theming or overriding the default form
 */

// Prevent direct access
if (!defined('ABSPATH')) {
    exit;
}

// Get settings directly within the template with plugin prefix
$syprayer_currency = isset($syprayer_settings['currency']) ? $syprayer_settings['currency'] : 'USD';
$syprayer_simple_amount = isset($syprayer_settings['simple_amount']) ? $syprayer_settings['simple_amount'] : 1;
$syprayer_form_description = isset($syprayer_settings['form_description']) ? $syprayer_settings['form_description'] : esc_html__('Share your prayer request with our community. Your prayer will be received and considered by our church.', 'send-your-prayers');

// Check if PayPal is available
$syprayer_paypal_available = !empty($syprayer_settings['paypal_client_id']) && !empty($syprayer_settings['paypal_client_secret']);
?>

<div id="send-your-prayers-form" class="syprayer-form-container">
    <div class="syprayer-header">
        <h3 class="syprayer-title"><?php echo esc_html__('Send Your Prayer', 'send-your-prayers'); ?></h3>
        <p class="syprayer-description"><?php echo esc_html($syprayer_form_description); ?></p>
    </div>

    <form id="syprayer-form" class="syprayer-form">
        <div class="syprayer-form-group">
            <label for="syprayer-email" class="syprayer-label">
                <?php echo esc_html__('Email Address', 'send-your-prayers'); ?> *
            </label>
            <input type="email" id="syprayer-email" name="email" class="syprayer-input" required 
                   placeholder="<?php echo esc_attr__('your.email@example.com', 'send-your-prayers'); ?>">
            <small class="syprayer-help-text"><?php echo esc_html__('We\'ll send a confirmation of your prayer submission to this address.', 'send-your-prayers'); ?></small>
        </div>
        
        <div class="syprayer-form-group">
            <label for="syprayer-prayer" class="syprayer-label">
                <?php echo esc_html__('Your Prayer Request', 'send-your-prayers'); ?> *
            </label>
            <textarea id="syprayer-prayer" name="prayer" class="syprayer-textarea" rows="6" required 
                      placeholder="<?php echo esc_attr__('Please share your prayer request here...', 'send-your-prayers'); ?>"></textarea>
            <small class="syprayer-help-text"><?php echo esc_html__('Share as much or as little as you feel comfortable. All prayers are treated with respect and confidentiality.', 'send-your-prayers'); ?></small>
        </div>
        
        <div class="syprayer-form-group">
            <label class="syprayer-label"><?php echo esc_html__('Payment Method', 'send-your-prayers'); ?></label>
            <div class="syprayer-payment-methods">
                <label class="syprayer-payment-method">
                    <input type="radio" name="payment_gateway" value="stripe" checked class="syprayer-radio">
                    <span class="syprayer-payment-title"><?php echo esc_html__('Credit/Debit Card', 'send-your-prayers'); ?></span>
                    <span class="syprayer-payment-icon">💳</span>
                </label>
                
                <?php if ($syprayer_paypal_available): ?>
                <label class="syprayer-payment-method">
                    <input type="radio" name="payment_gateway" value="paypal" class="syprayer-radio">
                    <span class="syprayer-payment-title"><?php echo esc_html__('PayPal', 'send-your-prayers'); ?></span>
                    <span class="syprayer-payment-icon">🔵</span>
                </label>
                <?php endif; ?>
            </div>
        </div>
        
        <!-- Stripe Payment Element -->
        <div class="syprayer-form-group" id="syprayer-stripe-payment-group">
            <label class="syprayer-label"><?php echo esc_html__('Card Details', 'send-your-prayers'); ?></label>
            <div id="syprayer-payment-element" class="syprayer-payment-element">
                <!-- Stripe Payment Element will be inserted here -->
            </div>
        </div>
        
        <div class="syprayer-form-group syprayer-terms-group">
            <label class="syprayer-checkbox-label">
                <input type="checkbox" id="syprayer-terms" name="terms" required class="syprayer-checkbox">
                <span class="syprayer-checkbox-text">
                    <?php echo esc_html__('I understand that this is a donation and prayer submissions are subject to review.', 'send-your-prayers'); ?>
                </span>
            </label>
        </div>
        
        <div class="syprayer-form-submit">
            <button type="submit" id="syprayer-submit-prayer" class="syprayer-submit-button">
                <span class="syprayer-button-text">
                    <span class="syprayer-button-amount" id="syprayer-button-amount">
                        <?php 
                        printf(
                            /* translators: 1: Currency code, 2: Amount value */
                            esc_html__('Submit Prayer - %1$s%2$s', 'send-your-prayers'), 
                            esc_html($syprayer_currency), 
                            esc_html($syprayer_simple_amount)
                        );
                        ?>
                    </span>
                </span>
                <span class="syprayer-spinner" style="display: none;"><?php echo esc_html__('Processing...', 'send-your-prayers'); ?></span>
            </button>
        </div>
        
        <div id="syprayer-form-messages" class="syprayer-messages"></div>
    </form>
    
    <div class="syprayer-footer">
        <p class="syprayer-footer-text">
            <?php echo esc_html__('Your support helps maintain our prayer ministry and community outreach programs. Thank you for your generosity.', 'send-your-prayers'); ?>
        </p>
    </div>
</div>