jQuery(document).ready(function($) {
    // Initialize color pickers
    $('.color-picker').wpColorPicker();
    
    // Settings page functionality
    if ($('.syprayer-settings-form').length) {
        // Show/hide fields based on test mode
        function toggleTestModeFields() {
            var stripeTestMode = $('#syprayer-stripe-test-mode').is(':checked');
            var paypalTestMode = $('#syprayer-paypal-test-mode').is(':checked');
            
            // Stripe fields
            if (stripeTestMode) {
                $('.stripe-test-fields').show();
                $('.stripe-live-fields').hide();
            } else {
                $('.stripe-test-fields').hide();
                $('.stripe-live-fields').show();
            }
            
            // PayPal fields (always show both since they're the same keys for test/live)
            // PayPal uses different URLs for test/live mode
        }
        
        // Initial toggle
        toggleTestModeFields();
        
        // Bind change events
        $('#syprayer-stripe-test-mode').on('change', toggleTestModeFields);
        $('#syprayer-paypal-test-mode').on('change', toggleTestModeFields);
        
        // Page preview functionality
        $('.syprayer-page-select').on('change', function() {
            var pageId = $(this).val();
            var previewUrl = $(this).next('.page-preview-url');
            
            if (pageId > 0) {
                $.ajax({
                    url: ajaxurl,
                    type: 'POST',
                    data: {
                        action: 'get_permalink',
                        page_id: pageId
                    },
                    success: function(response) {
                        if (response.success) {
                            previewUrl.text('URL: ' + response.data).show();
                        }
                    }
                });
            } else {
                previewUrl.hide();
            }
        });
        
        // Test connection buttons
        $('.test-connection').on('click', function(e) {
            e.preventDefault();
            var button = $(this);
            var gateway = button.data('gateway');
            var originalText = button.text();
            
            button.text('Testing...').prop('disabled', true);
            
            $.ajax({
                url: ajaxurl,
                type: 'POST',
                data: {
                    action: 'syprayer_test_gateway_connection',
                    gateway: gateway,
                    nonce: syprayer_admin.nonce
                },
                success: function(response) {
                    if (response.success) {
                        alert(response.data.message);
                    } else {
                        alert('Error: ' + response.data.message);
                    }
                    button.text(originalText).prop('disabled', false);
                },
                error: function() {
                    alert('Connection test failed. Please check your settings.');
                    button.text(originalText).prop('disabled', false);
                }
            });
        });
        
        // Copy to clipboard functionality
        $('.copy-to-clipboard').on('click', function(e) {
            e.preventDefault();
            var text = $(this).data('text');
            var $temp = $('<input>');
            $('body').append($temp);
            $temp.val(text).select();
            document.execCommand('copy');
            $temp.remove();
            
            var originalText = $(this).text();
            $(this).text('Copied!');
            setTimeout(function() {
                $(this).text(originalText);
            }.bind(this), 2000);
        });
    }
    
    // Submissions page functionality
    if ($('.syprayer-submissions-page').length) {
        // Date range picker
        $('.date-range-picker').on('apply.daterangepicker', function(ev, picker) {
            $(this).val(picker.startDate.format('YYYY-MM-DD') + ' to ' + picker.endDate.format('YYYY-MM-DD'));
        });
        
        // Bulk actions
        $('.bulk-action-select').on('change', function() {
            var action = $(this).val();
            if (action) {
                var checked = $('.bulk-select:checked');
                if (checked.length === 0) {
                    alert('Please select at least one submission.');
                    $(this).val('');
                    return;
                }
                
                var ids = [];
                checked.each(function() {
                    ids.push($(this).val());
                });
                
                if (confirm('Are you sure you want to ' + action + ' the selected submissions?')) {
                    $.ajax({
                        url: ajaxurl,
                        type: 'POST',
                        data: {
                            action: 'syprayer_bulk_action_submissions',
                            bulk_action: action,
                            submission_ids: ids,
                            nonce: syprayer_admin.nonce
                        },
                        success: function(response) {
                            if (response.success) {
                                alert(response.data.message);
                                location.reload();
                            } else {
                                alert('Error: ' + response.data.message);
                            }
                        }
                    });
                }
                
                $(this).val('');
            }
        });
        
        // Quick edit prayer
        $('.quick-edit-prayer').on('click', function(e) {
            e.preventDefault();
            var prayerId = $(this).data('id');
            var prayerText = $(this).data('text');
            
            $('#quick-edit-prayer-id').val(prayerId);
            $('#quick-edit-text').val(prayerText);
            $('#quick-edit-modal').show();
        });
        
        // Close modal
        $('.modal-close, .cancel-edit').on('click', function() {
            $('#quick-edit-modal').hide();
        });
        
        // Save quick edit
        $('#save-quick-edit').on('click', function() {
            var prayerId = $('#quick-edit-prayer-id').val();
            var prayerText = $('#quick-edit-text').val();
            
            if (!prayerText.trim()) {
                alert('Please enter prayer text.');
                return;
            }
            
            $.ajax({
                url: ajaxurl,
                type: 'POST',
                data: {
                    action: 'syprayer_quick_edit_prayer',
                    prayer_id: prayerId,
                    prayer_text: prayerText,
                    nonce: syprayer_admin.nonce
                },
                success: function(response) {
                    if (response.success) {
                        alert('Prayer updated successfully.');
                        location.reload();
                    } else {
                        alert('Error: ' + response.data.message);
                    }
                }
            });
        });
    }
    
    // Dashboard functionality
    if ($('.syprayer-dashboard-page').length) {
        // Load dashboard stats
        function loadDashboardStats() {
            $.ajax({
                url: ajaxurl,
                type: 'POST',
                data: {
                    action: 'syprayer_get_dashboard_stats',
                    nonce: syprayer_admin.nonce
                },
                success: function(response) {
                    if (response.success) {
                        // Update stats cards
                        $('#total-submissions').text(response.data.total_submissions);
                        $('#total-revenue').text(response.data.total_revenue);
                        $('#today-submissions').text(response.data.today_submissions);
                        $('#monthly-revenue').text(response.data.monthly_revenue);
                        
                        // Update chart if exists
                        if (typeof updateRevenueChart === 'function') {
                            updateRevenueChart(response.data.revenue_chart);
                        }
                    }
                }
            });
        }
        
        // Auto-refresh dashboard every 5 minutes
        setInterval(loadDashboardStats, 300000);
        
        // Export data
        $('.export-data').on('click', function(e) {
            e.preventDefault();
            var format = $(this).data('format');
            var period = $(this).data('period');
            
            $.ajax({
                url: ajaxurl,
                type: 'POST',
                data: {
                    action: 'syprayer_export_data',
                    format: format,
                    period: period,
                    nonce: syprayer_admin.nonce
                },
                xhrFields: {
                    responseType: 'blob'
                },
                success: function(data) {
                    var blob = new Blob([data], { type: format === 'csv' ? 'text/csv' : 'application/json' });
                    var link = document.createElement('a');
                    link.href = window.URL.createObjectURL(blob);
                    link.download = 'syprayer-data-' + new Date().toISOString().split('T')[0] + (format === 'csv' ? '.csv' : '.json');
                    link.click();
                }
            });
        });
    }
    
    // Tooltips
    $('.syprayer-tooltip').hover(function() {
        var tooltip = $(this).data('tooltip');
        $('body').append('<div class="syprayer-tooltip-content">' + tooltip + '</div>');
        $('.syprayer-tooltip-content').css({
            position: 'absolute',
            left: $(this).offset().left,
            top: $(this).offset().top - 30,
            background: '#333',
            color: '#fff',
            padding: '5px 10px',
            borderRadius: '4px',
            fontSize: '12px',
            zIndex: '9999'
        }).show();
    }, function() {
        $('.syprayer-tooltip-content').remove();
    });
    
    // Confirm delete actions
    $('.syprayer-confirm-delete').on('click', function(e) {
        if (!confirm('Are you sure you want to delete this? This action cannot be undone.')) {
            e.preventDefault();
            return false;
        }
    });
    
    // Toggle advanced settings
    $('.toggle-advanced-settings').on('click', function(e) {
        e.preventDefault();
        var target = $(this).data('target');
        $(target).slideToggle();
        $(this).text($(target).is(':visible') ? 'Hide Advanced Settings' : 'Show Advanced Settings');
    });
});