<?php
/**
 * This file is part of the Magebit_Selfnamed package.
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade to newer
 * versions in the future.
 *
 * Selfnamed: Cosmetics on demand extension is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * @package Magebit_Selfnamed
 */

namespace Selfnamed\ViewModel;

use Selfnamed\Model\Product as ProductModel;

/**
 * Product class.
 */
class Product {
	/**
	 * Pagination view model.
	 *
	 * @var Pagination
	 */
	public $pagination;

	/**
	 * Product model.
	 *
	 * @var ProductModel
	 */
	private $model;

	/**
	 * Constructor.
	 */
	public function __construct() {
		$this->pagination = new Pagination();
		$this->model      = new ProductModel();
	}

	/**
	 * Get selfnamed products.
	 *
	 * @return array
	 */
	public function get_products(): array {
		$response = $this->model->get_products( $this->pagination->cur_page );

		if ( $response->error ) {
			return array();
		}

		$this->pagination = $response->pagination;

		return $response->data;
	}

	/**
	 * Create a new selfnamed products in the WooCommerce.
	 *
	 * @param object $product The product data.
	 *
	 * @return int|mixed|null
	 */
	public function create_product( object $product ) {
		return $this->model->create_product( $product );
	}
}
