<?php
/**
 * This file is part of the Magebit_Selfnamed package.
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade to newer
 * versions in the future.
 *
 * Selfnamed: Cosmetics on demand extension is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * @package Magebit_Selfnamed
 */

namespace Selfnamed\ViewModel;

/**
 * Pagination class.
 */
class Pagination {
	/**
	 * Current page.
	 *
	 * @var int
	 */
	public $cur_page = 1;

	/**
	 * Pages.
	 *
	 * @var int
	 */
	public $pages = 0;

	/**
	 * Total.
	 *
	 * @var int
	 */
	public $total = 0;

	/**
	 * Items size.
	 *
	 * @var int
	 */
	public $size = 0;

	/**
	 * Constructor.
	 *
	 * @param int $cur_page The current page.
	 * @param int $pages The amount of pages.
	 * @param int $total The amount of total.
	 * @param int $size The size of page.
	 */
	public function __construct( int $cur_page = 1, int $pages = 0, int $total = 0, int $size = 0 ) {
		$this->cur_page = $cur_page;
		$this->size     = $size;
		$this->pages    = $pages;
		$this->total    = $total;

		if ( array_key_exists( 'p', $_REQUEST ) ) {
			$this->cur_page = (int) wp_strip_all_tags( (string) sanitize_text_field( wp_unslash( $_REQUEST['p'] ) ) );
		}
	}

	/**
	 * Render the pagination on the page.
	 *
	 * @return string
	 */
	public function render(): string {
		if ( 0 === $this->total || 0 === $this->pages ) {
			return '';
		}

		$pages      = '';
		$total_word = 'item' . ( 1 === $this->total ? '' : 's' );

		if ( $this->pages > 1 ) {
			for ( $i = 1; $i <= $this->pages; $i++ ) {
				$class_name = $this->cur_page === $i ? 'button-primary' : '';
				$href       = add_query_arg( array( 'p' => $i ) );
				$pages     .= "<a href=\"$href\" class=\"button button-page $class_name\">$i</a>";
			}
		}

		return "<div class=\"tablenav-pages\">
        <span class=\"displaying-num\">$this->total $total_word</span>
        <div class=\"pagination-links\">$pages</div>
    </div>";
	}
}
