<?php
/**
 * This file is part of the Magebit_Selfnamed package.
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade to newer
 * versions in the future.
 *
 * Selfnamed: Cosmetics on demand extension is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * @package Magebit_Selfnamed
 */

namespace Selfnamed\ViewModel;

use Selfnamed\Model\Api;

/**
 * Delivery class.
 */
class Delivery {
	/**
	 * If the section is ready/visible.
	 *
	 * @var bool
	 */
	public $ready;

	/**
	 * Api model.
	 *
	 * @var Api
	 */
	private $api;

	/**
	 * Constructor.
	 */
	public function __construct() {
		$this->ready = (bool) get_option( 'selfnamed_api' );
		$this->api   = new Api();
	}

	/**
	 * Get shipping methods.
	 *
	 * @return array
	 */
	public function get_methods() {
		$result = $this->api->get_all_shipping_zones();

		if ( $result->error ) {
			return array();
		}

		return $result->data;
	}
}
