<?php
/**
 * This file is part of the Magebit_Selfnamed package.
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade to newer
 * versions in the future.
 *
 * Selfnamed: Cosmetics on demand extension is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * @package Magebit_Selfnamed
 */

namespace Selfnamed\Model;

/**
 * Admin_Ajax_Actions class.
 */
class Admin_Ajax_Actions {
	const SYNC_ALL_BATCH_SIZE = 5;

	/**
	 * Product model.
	 *
	 * @var Product
	 */
	private $product;

	/**
	 * Initialization.
	 *
	 * @return void
	 */
	public static function create() {
		new self();
	}

	/**
	 * Constructor.
	 */
	public function __construct() {
		$this->product = new Product();
		$this->register_ajax_actions();
	}

	/**
	 * Register ajax actions to sync products.
	 *
	 * @return void
	 */
	public function register_ajax_actions(): void {
		add_action( 'wp_ajax_sn_get_sync_batch_info', array( $this, 'get_sync_batch_info' ), 1 );
		add_action( 'wp_ajax_sn_sync_all_products', array( $this, 'sync_all_products' ), 1 );
	}


	/**
	 * Get sync batch information.
	 *
	 * @return void
	 */
    public function get_sync_batch_info() {
        check_ajax_referer( 'sn_get_sync_batch_info', 'selfnamed_nonce' );

		if ( ! current_user_can( 'manage_woocommerce' ) ) {
			wp_send_json_error( __( 'Insufficient permissions.', 'selfnamed-cosmetics-on-demand' ), 403 );
		}

		try {
			$response = $this->product->get_products( 1, self::SYNC_ALL_BATCH_SIZE );

			if ( $response->error ) {
				wp_send_json_error(
					$response->response,
					500
				);
			} else {
				wp_send_json_success( $response->pagination );
			}
		} catch ( \Exception $e ) {
			wp_send_json_error(
				$e->getMessage(),
				500
			);
		}
	}

	/**
	 * Sync all products action.
	 *
	 * @return void
	 */
    public function sync_all_products() {
        check_ajax_referer( 'sn_sync_all_products', 'selfnamed_nonce' );
        if ( ! current_user_can( 'manage_woocommerce' ) ) {
            wp_send_json_error( __( 'Insufficient permissions.', 'selfnamed-cosmetics-on-demand' ), 403 );
        }
		try {
			$result = $this->product->create_all_products( (int) $_REQUEST['page'] ?? 1, self::SYNC_ALL_BATCH_SIZE );

			if ( $result ) {
				wp_send_json_success( array( 'synced' => 'OK' ) );
			} else {
				wp_send_json_error(
					__( 'Something went wrong while syncing products, try again later', 'selfnamed-cosmetics-on-demand' ),
					500
				);
			}
		} catch ( \Exception $e ) {
			wp_send_json_error(
				$e->getMessage(),
				500
			);
		}
	}
}
