<?php
/**
 * Plugin Name: Selfnamed: Cosmetics on demand
 * Plugin URI: https://www.selfnamed.com
 * Description: Create and sell organic & vegan skincare products trough print-on-demand dropshipping.
 * Version: 2.0.17
 * Requires at least: 6.1
 * Requires PHP: 7.4
 * Author: Selfnamed
 * Text Domain: selfnamed-cosmetics-on-demand
 * License: GPLv3 or later
 * License URI: https://www.gnu.org/licenses/gpl-3.0.html
 *
 * WC requires at least: 7.4
 * WC tested up to: 9.3
 *
 * Selfnamed: Cosmetics on demand extension is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * @package Magebit_Selfnamed
 */

use Selfnamed\Model\Shipping_Method;
use Selfnamed\Model\Admin_Ajax_Actions;
use Selfnamed\Model\Notification;
use Selfnamed\Model\Order_Flags;
use Selfnamed\Model\Upgrader;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( ! defined( 'SELFNAMED_VERSION' ) ) {
	define( 'SELFNAMED_VERSION', '2.0.17' );
}

if ( ! defined( 'SELFNAMED_PLUGIN_PATH' ) ) {
	define( 'SELFNAMED_PLUGIN_PATH', __FILE__ );
}

//if (!defined('FS_CHMOD_FILE')) {
//	define( 'FS_CHMOD_FILE', '0664' );
//}

require_once plugin_dir_path(SELFNAMED_PLUGIN_PATH) . 'autoloader.php';

// Test to see if WooCommerce is active (including network activated).
$selfnamed_plugin_path = plugin_dir_path(WP_PLUGIN_DIR) . 'plugins/woocommerce/woocommerce.php';

if (
	in_array( $selfnamed_plugin_path, wp_get_active_and_valid_plugins() )
    || (is_multisite() && in_array($selfnamed_plugin_path, wp_get_active_network_plugins()))
) {
	include_once plugin_dir_path(SELFNAMED_PLUGIN_PATH) . 'includes/admin/class-sn-init-navigation.php';
	include_once plugin_dir_path(SELFNAMED_PLUGIN_PATH) . 'includes/admin/class-sn-admin-assets.php';

	add_action( 'init', 'selfnamed_init', 100 );
	$selfnamed_api = '';

	/**
	 * Initialization.
	 *
	 * @return void
	 */
	function selfnamed_init() {
		Shipping_Method::create();
		Admin_Ajax_Actions::create();
		Notification::create();
		Order_Flags::create();
		if ( is_admin() ) {
			Upgrader::create();
		}
	}
}

add_action( 'before_woocommerce_init', function() {
	if ( class_exists( \Automattic\WooCommerce\Utilities\FeaturesUtil::class ) ) {
		\Automattic\WooCommerce\Utilities\FeaturesUtil::declare_compatibility( 'custom_order_tables', __FILE__, true );
	}
} );

// Require WP Filesystem
require_once ABSPATH . 'wp-admin/includes/file.php';

if( !class_exists( 'WP_Filesystem_Direct' ) ) {
    require_once ABSPATH . 'wp-admin/includes/class-wp-filesystem-base.php';
    require_once ABSPATH . 'wp-admin/includes/class-wp-filesystem-direct.php';
}

// Initialize WP Filesystem
WP_Filesystem();

/**
 * Activation: store current plugin version.
 */
register_activation_hook( __FILE__, 'selfnamed_activate' );
function selfnamed_activate() {
	$version = selfnamed_get_current_plugin_version();
	if ( $version ) {
		update_option( 'selfnamed_plugin_version', $version );
	}
}

/**
 * Helper: get version from plugin header.
 *
 * @return string
 */
function selfnamed_get_current_plugin_version() {
	if ( ! function_exists( 'get_plugin_data' ) ) {
		require_once ABSPATH . 'wp-admin/includes/plugin.php';
	}

	$data = get_plugin_data( __FILE__ );
	return isset( $data['Version'] ) ? (string) $data['Version'] : '';
}
