<?php
/**
 * This file is part of the Magebit_Selfnamed package.
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade to newer
 * versions in the future.
 *
 * Selfnamed: Cosmetics on demand extension is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * @package Magebit_Selfnamed
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

use Selfnamed\ViewModel\Product;

$selfnamed_product_model = new Product();
$selfnamed_products      = $selfnamed_product_model->get_products();

if ( array_key_exists( 'action', $_REQUEST ) && 'sync_individual' === $_REQUEST['action'] ) {
	check_admin_referer( 'selfnamed-sync-individual', 'selfnamed_nonce' );
    if ( ! current_user_can( 'manage_woocommerce' ) ) {
        wp_die( esc_html__( 'Insufficient permissions.', 'selfnamed-cosmetics-on-demand' ) );
    }
	$selfnamed_product    = null;
	$selfnamed_index      = 0;
	$selfnamed_product_id = (int) $_REQUEST['product_id'] ?? false;

	foreach ( $selfnamed_products as $selfnamed_idx => $selfnamed_item ) {
		if ( (int) $selfnamed_item->id === $selfnamed_product_id ) {
			$selfnamed_product = $selfnamed_item;
			$selfnamed_index   = $selfnamed_idx;
			break;
		}
	}

	if ( $selfnamed_product && ! $selfnamed_product->synced ) {
		$selfnamed_wc_id                                 = $selfnamed_product_model->create_product( $selfnamed_product );
		$selfnamed_products[ $selfnamed_index ]->synced = true;
		$selfnamed_products[ $selfnamed_index ]->wc_id  = $selfnamed_wc_id;
	}
}

$selfnamed_sync_all_products_template = 'products/html-sync-all-products-modal.php'; ?>

<div class="container">
	<div class="action-list">
		<button
				type="button"
				name="action"
				value="sync_all"
				class="button button-large button-primary"
				id="sync_all_products"
		>
			Synchronize All Products
		</button>
		<form method="post">
			<button type="submit" name="action" value="refresh" class="button button-large">
				Refresh
			</button>
		</form>
	</div>
	<?php require_once $selfnamed_sync_all_products_template; ?>
	<table>
		<tr>
			<th></th>
			<th>Name</th>
			<th>Description</th>
			<th>Price</th>
			<th>Tags</th>
			<th>Stock Status</th>
			<th>Status</th>
			<th>Actions</th>
		</tr>
		<?php foreach ( $selfnamed_products as $selfnamed_product ) : ?>
			<tr>
				<td><img width="40" height="40" alt="<?php echo esc_attr( $selfnamed_product->name . 'image' ); ?>"
						src="<?php echo esc_url( reset( $selfnamed_product->images ) ); ?>"/></td>
				<td>
					<?php if ( $selfnamed_product->wc_id ) : ?>
						<a href="<?php echo esc_url( get_edit_post_link( $selfnamed_product->wc_id ) ); ?>">
							<?php echo esc_html( $selfnamed_product->name ); ?>
						</a>
					<?php else : ?>
						<?php echo esc_html( $selfnamed_product->name ); ?>
					<?php endif; ?>
				</td>
				<td>
					<?php echo esc_html( wp_trim_words( $selfnamed_product->description, 5, '...' ) ); ?>
				</td>
				<td><?php echo wp_kses_post( wc_price( (float) $selfnamed_product->price ) ); ?></td>
				<td>
					<?php foreach ( $selfnamed_product->tags as $selfnamed_tag ) : ?>
						<span><?php echo esc_html( $selfnamed_tag ); ?></span>
					<?php endforeach; ?>
				</td>
				<td>
					<?php if ( $selfnamed_product->is_in_stock ) : ?>
						<span class="success">In Stock</span>
					<?php else : ?>
						<span class="alert">Out Of Stock</span>
					<?php endif; ?>
				</td>
				<td>
					<?php
					echo $selfnamed_product->synced
						? '<span class="success">Synced</span>'
						: '<span class="alert">Not synced</span>'
					?>
				</td>
				<td>
					<form method="post">
						<?php wp_nonce_field( 'selfnamed-sync-individual', 'selfnamed_nonce' ); ?>
						<input type="hidden" name="product_id" value="<?php echo esc_attr( $selfnamed_product->id ); ?>"/>
						<button
								type="submit"
								name="action"
								value="sync_individual"
								class="button-large button-secondary button"
						>
							Sync
						</button>
					</form>
				</td>
			</tr>
		<?php endforeach; ?>
	</table>
	<div class="tablenav bottom">
		<?php echo wp_kses_post( $selfnamed_product_model->pagination->render() ); ?>
	</div>
</div>
