<?php
/**
 * This file is part of the Magebit_Selfnamed package.
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade to newer
 * versions in the future.
 *
 * Selfnamed: Cosmetics on demand extension is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * @package Magebit_Selfnamed
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

use Selfnamed\ViewModel\Orders;
require_once dirname( SELFNAMED_PLUGIN_PATH ) . '/includes/admin/class-sn-admin-ui.php';

$selfnamed_orders = new Orders();
$selfnamed_orders->handle_actions();
$selfnamed_orders->get_orders_list();

?>
<div class="container">
    <div class="action-list">
		<div class="action-list-left">
			<button class="button button-large button-primary" id="sn-sync-selected">Synchronize selected</button>
			<a href="<?php echo esc_url( $selfnamed_orders->get_page_url() ); ?>" class="button button-large">Refresh</a>
		</div>
        <div class="action-list-right">
            <?php Selfnamed_Admin_UI::render_pagination($selfnamed_orders->current_page, $selfnamed_orders->total_pages, $selfnamed_orders->total_items, $selfnamed_orders->get_page_url(true)); ?>
		</div>
    </div>
	<div class="sn-table-container">
		<form id="sn-orders-form" method="post">
			<table>
				<tr>
					<th style="min-width:52px; padding-right:0;">
						<label id="sn-select-all">
							<input type="checkbox" /> 
							<span title="Selected orders">0</span>
						</label>
					</th>
					<th>Order</th>
					<th>Customer</th>
					<th style="white-space: nowrap;">Planned Delivery</th>
					<th style="white-space: nowrap;">Tracking Numbers</th>
					<th style="min-width: 200px;">Message</th>
					<th>Status</th>
					<th>Updated At</th>
				</tr>
				<?php foreach ( $selfnamed_orders->selfnamed_orders as $selfnamed_order ) : ?>
					<tr>
						<td><input type="checkbox" name="order_ids[]" value="<?php echo esc_attr( (string) $selfnamed_order['id'] ); ?>" /></td>
						<td>
							<a href="<?php echo esc_url( $selfnamed_order['link'] ); ?>"><?php echo esc_html( $selfnamed_order['name'] ); ?></a>
						</td>
						<td style="white-space: nowrap;"><?php echo esc_html( $selfnamed_order['customer'] ); ?></td>
						<td style="white-space: nowrap;"><?php echo esc_html( $selfnamed_order['planned_delivery'] ); ?></td>
						<td>
							<?php $selfnamed_tracking_numbers = $selfnamed_orders->get_tracking_numbers( $selfnamed_order['id'] ); ?>
							<?php if ( count( $selfnamed_tracking_numbers ) ) : ?> 
								<div class="orders-table-tracking-numbers">
									<?php foreach ( $selfnamed_tracking_numbers as $selfnamed_key => $selfnamed_tracking_number ) : ?>
										<a href="<?php echo esc_url( $selfnamed_tracking_number['url'] ); ?>"><?php echo esc_html( $selfnamed_tracking_number['number'] ); ?></a>
									<?php endforeach; ?>
								</div>
							<?php endif; ?>
						</td>
						<td><?php echo esc_html( $selfnamed_order['message'] ); ?></td>
						<td style="white-space: nowrap;"><?php echo wp_kses_post( $selfnamed_orders->get_order_status( $selfnamed_order['id'] ) ); ?></td>
						<td style="white-space: nowrap;"><?php echo esc_html( $selfnamed_orders->format_date( $selfnamed_order['updated_at'] ) ); ?></td>
					</tr>
				<?php endforeach; ?>
			</table>
		</form>
	</div>
	<div class="action-list">
		<div class="action-list-left">
		<?php Selfnamed_Admin_UI::render_items_per_page($selfnamed_orders->per_page); ?>
		</div>
        <div class="action-list-right">
            <?php Selfnamed_Admin_UI::render_pagination($selfnamed_orders->current_page, $selfnamed_orders->total_pages, $selfnamed_orders->total_items, $selfnamed_orders->get_page_url(true), [ 'show_page_input' => false ] ); ?>
		</div>
    </div>
</div>

<style lang="css">
	.alert {
		font-weight: 500;
		color: var(--wc-red);
	}
	.grey {
		font-weight: 500;
		color: var(--wc-subtext);
	}
</style>

<script>
	jQuery(document).ready(function($) {
		window.sn_admin_form = new window.sn_admin.bulk_actions('#sn-orders-form');
		window.sn_admin_form.initBulkActionButton('#sn-sync-selected', 'sync_selected', '<?php echo esc_attr( wp_create_nonce( 'selfnamed-orders-sync' ) ); ?>');
	});
</script>
