<?php
/**
 * This file is part of the Magebit_Selfnamed package.
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade to newer
 * versions in the future.
 *
 * Selfnamed: Cosmetics on demand extension is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * @package Magebit_Selfnamed
 */

use Selfnamed\Model\Setup;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

$selfnamed_setup               = new Setup();
$selfnamed_billing_information = $selfnamed_setup->get_billing_information();

$selfnamed_is_using_custom_shipping_profile = json_decode( get_option( Setup::IS_USING_CUSTOM_SHIPPING_PROFILE ) );
?>

<div class="step-box">
	<h3>
		Step 1 - Connect your WooCommerce store:
	</h3>
	<p>
		To begin, obtain the API key by logging into or signing up for SELFNAMED. Then, copy the API key and paste it
		into the designated input form. You can find the API key on the SELFNAMED platform under My stores -&gt; Connect
		now.
	</p>
    <form class="setting-form" method="post">
        <?php wp_nonce_field( 'selfnamed-save-api-key', 'selfnamed_nonce' ); ?>
		<h4>API KEY</h4>
		<input name="apiKey" value="<?php echo esc_attr( $selfnamed_setup->get_api_key() ); ?>" type="text"/>
		<button type="submit" name="action" value="save_api_key" class="button button-primary">
			Save
		</button>
	</form>
</div>

<div class="step-box">
	<h3>
		Step 2 - Add products to your WooCommerce store:
	</h3>
	<p>
		Proceed to WooCommerce Products -&gt; Synchronize to add your products to the store and commence selling. You
		have
		the
		option to create customized beauty products from scratch or utilize pre-existing product templates. This step
		will synchronize the products from the SELFNAMED platform.
	</p>
</div>
<div class="step-box">
	<h3>
		Step 3 - Set up shipping methods:
	</h3>
	<p>
		- To use your own shipping methods
		<?php if ( $selfnamed_is_using_custom_shipping_profile ) : ?>
			<strong>(currently selected)</strong>
		<?php endif; ?>
	</p>
	<p>
		Make sure to select the «I want to use my own shipping settings» on the SELFNAMED platform under your profile ->
		Shipping. Disable the Selfnamed Shipping under the Delivery tab -> Configure -> deselected the «Enable this
		shipping method» option. After that, you can specify your own shipping methods under WooCommerce settings.
	</p>
	<p>
		- To use the pre-defined SELFNAMED shipping methods
		<?php if ( ! $selfnamed_is_using_custom_shipping_profile ) : ?>
			<strong>(currently selected)</strong>
		<?php endif; ?>
	</p>
	<p>
		Make sure to select the «Selfnamed shipping profile» on the SELFNAMED platform under your profile -> Shipping.
		Enable the Selfnamed Shipping in under the Delivery tab -> Configure -> select the «Enable this shipping
		method» option.
	</p>
</div>
<div class="step-box">
	<h3>
		Step 4 - Set up billing:
	</h3>
	<p>
		Visit your SELFNAMED profile and input a valid billing method to ensure successful order processing.
	</p>
</div>

<div class="step-box">
	<h3>
		Step 5 - Fill your billing information:
	</h3>
	<p>
		Enter your company's billing information for invoice generation when shipping your orders to customers.
	</p>
	<form class="setting-form" method="post">
		<?php wp_nonce_field( 'selfnamed-save-billing', 'selfnamed_nonce' ); ?>
		<table class="form-table">
			<tbody>
			<tr class="form-field">
				<th scope="row" valign="top">
					<label for="name">Company Name</label>
				</th>
				<td>
					<input id="name" name="name" value="<?php echo esc_attr( $selfnamed_billing_information['name'] ); ?>"
							type="text"/>
				</td>
			</tr>
			<tr class="form-field">
				<th scope="row" valign="top">
					<label for="vatNr">VAT Number</label>
				</th>
				<td>
					<input id="vatNr" name="vatNr" value="<?php echo esc_attr( $selfnamed_billing_information['vatNr'] ); ?>"
							type="text"/>
				</td>
			</tr>
			<tr class="form-field">
				<th scope="row" valign="top">
					<label for="regNr">Registration Number</label>
				</th>
				<td>
					<input id="regNr" name="regNr" value="<?php echo esc_attr( $selfnamed_billing_information['regNr'] ); ?>"
							type="text"/>
				</td>
			</tr>
			<tr class="form-field">
				<th scope="row" valign="top">
					<label for="country">Country</label>
				</th>
				<td>
					<input id="country" name="country"
							value="<?php echo esc_attr( $selfnamed_billing_information['country'] ); ?>" type="text"/>
				</td>
			</tr>
			<tr class="form-field">
				<th scope="row" valign="top">
					<label for="city">City</label>
				</th>
				<td>
					<input id="city" name="city" value="<?php echo esc_attr( $selfnamed_billing_information['city'] ); ?>"
							type="text"/>
				</td>
			</tr>
			<tr class="form-field">
				<th scope="row" valign="top">
					<label for="street">Street</label>
				</th>
				<td>
					<input id="street" name="street" value="<?php echo esc_attr( $selfnamed_billing_information['street'] ); ?>"
							type="text"/>
				</td>
			</tr>
			<tr class="form-field">
				<th scope="row" valign="top">
					<label for="streetNo">Street Number</label>
				</th>
				<td>
					<input id="streetNo" name="streetNo"
							value="<?php echo esc_attr( $selfnamed_billing_information['streetNo'] ); ?>" type="text"/>
				</td>
			</tr>
			<tr class="form-field">
				<th scope="row" valign="top">
					<label for="flatNo">Flat Number</label>
				</th>
				<td>
					<input id="flatNo" name="flatNo" value="<?php echo esc_attr( $selfnamed_billing_information['flatNo'] ); ?>"
							type="text"/>
				</td>
			</tr>
			<tr class="form-field">
				<th scope="row" valign="top">
					<label for="zip">ZIP</label>
				</th>
				<td>
					<input id="zip" name="zip" value="<?php echo esc_attr( $selfnamed_billing_information['zip'] ); ?>"
							type="text"/>
				</td>
			</tr>
			<tr class="form-field">
				<th scope="row" valign="top">
					<label for="phone">Phone Number</label>
				</th>
				<td>
					<input id="phone" name="phone" value="<?php echo esc_attr( $selfnamed_billing_information['phone'] ); ?>"
							type="text"/>
				</td>
			</tr>
			<tr class="form-field">
				<th scope="row" valign="top">
					<label for="email">Email</label>
				</th>
				<td>
					<input id="email" name="email" value="<?php echo esc_attr( $selfnamed_billing_information['email'] ); ?>"
							type="text"/>
				</td>
			</tr>
			</tbody>
		</table>
		<button type="submit" name="action" value="save_billing_information" class="button button-primary">
			Save
		</button>
	</form>
</div>
