<?php
/**
 * This file is part of the Magebit_Selfnamed package.
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade to newer
 * versions in the future.
 *
 * Selfnamed: Cosmetics on demand extension is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * @package Magebit_Selfnamed
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

use Selfnamed\ViewModel\Delivery;

$selfnamed_delivery_model     = new Delivery();
$selfnamed_methods            = $selfnamed_delivery_model->get_methods();
$selfnamed_shipping_admin_url = admin_url( 'admin.php?page=wc-settings&tab=shipping&section=selfnamed_shipping' ); ?>

<div class="container">
	<div class="action-list">
		<button
				type="button"
				onclick="window.location = '<?php echo esc_url( $selfnamed_shipping_admin_url ); ?>'"
				class="button button-primary"
		>
			Configure
		</button>
		<form method="get">
			<input type="submit" name="reload" class="button button-large" value="Refresh"/>
		</form>
	</div>
	<table>
		<thead>
		<tr>
			<th>Shipping Method Title</th>
			<th>Countries</th>
			<th>Threshold</th>
			<th>Price</th>
		</tr>
		</thead>
		<tbody>
		<?php if ( is_array( $selfnamed_methods ) ) : ?>
			<?php foreach ( $selfnamed_methods as $selfnamed_method ) : ?>
				<?php foreach ( $selfnamed_method->rates as $selfnamed_rate ) : ?>
					<tr>
						<td><?php echo esc_html( ucfirst( strtolower( $selfnamed_method->{'shippingGroup'} ) ) ); ?></td>
						<td>
							<?php foreach ( $selfnamed_method->countries as $selfnamed_country ) : ?>
								<span><?php echo esc_html( $selfnamed_country ); ?></span>
							<?php endforeach; ?>
						</td>
						<td><?php echo esc_html( $selfnamed_rate->{'totalWeightFrom'} . 'g - ' . $selfnamed_rate->{'totalWeightTo'} . 'g' ); ?></td>
						<td><?php echo esc_html( $selfnamed_rate->price . ' EUR' ); ?></td>
					</tr>
				<?php endforeach; ?>
			<?php endforeach; ?>
		<?php endif; ?>
		</tbody>
	</table>
</div>
