<?php
/**
 * This file is part of the Magebit_Selfnamed package.
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade to newer
 * versions in the future.
 *
 * Selfnamed: Cosmetics on demand extension is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * @package Magebit_Selfnamed
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

use Selfnamed\Model\Setup;

$selfnamed_setup = new Setup();
$selfnamed_admin_notice = '';
$selfnamed_notice_type = 'success';

if ( array_key_exists( 'action', $_REQUEST ) && 'save_api_key' === $_REQUEST['action'] ) {
    check_admin_referer( 'selfnamed-save-api-key', 'selfnamed_nonce' );
    if ( ! current_user_can( 'manage_woocommerce' ) ) {
        wp_die( esc_html__( 'Insufficient permissions.', 'selfnamed-cosmetics-on-demand' ) );
    }
	$selfnamed_old_key = $selfnamed_setup->get_api_key();
	if ( isset( $_REQUEST['apiKey'] ) ) {
		$selfnamed_setup->set_api_key( sanitize_text_field( wp_unslash( $_REQUEST['apiKey'] ) ) );
	} else {
		$selfnamed_setup->set_api_key( '' );
	}
	$selfnamed_new_key = $selfnamed_setup->get_api_key();
	
	// Check if the key was actually saved
	if ( ! empty( $_REQUEST['apiKey'] ) && $selfnamed_old_key === $selfnamed_new_key && $selfnamed_old_key !== sanitize_text_field( wp_unslash( $_REQUEST['apiKey'] ) ) ) {
		$selfnamed_admin_notice = __( 'Failed to save API key. Please check that the key is valid and try again.', 'selfnamed-cosmetics-on-demand' );
		$selfnamed_notice_type = 'error';
	} elseif ( ! empty( $_REQUEST['apiKey'] ) ) {
		$selfnamed_admin_notice = __( 'API key saved successfully!', 'selfnamed-cosmetics-on-demand' );
	} else {
		$selfnamed_admin_notice = __( 'API key removed successfully.', 'selfnamed-cosmetics-on-demand' );
	}
}

if ( array_key_exists( 'action', $_REQUEST ) && 'save_billing_information' === $_REQUEST['action'] ) {
	check_admin_referer( 'selfnamed-save-billing', 'selfnamed_nonce' );
    if ( ! current_user_can( 'manage_woocommerce' ) ) {
        wp_die( esc_html__( 'Insufficient permissions.', 'selfnamed-cosmetics-on-demand' ) );
    }
	$selfnamed_name      = array_key_exists( 'name', $_REQUEST ) ? sanitize_text_field( wp_unslash( $_REQUEST['name'] ) ) : '';
	$selfnamed_country   =
		array_key_exists( 'country', $_REQUEST ) ? sanitize_text_field( wp_unslash( $_REQUEST['country'] ) ) : '';
	$selfnamed_city      = array_key_exists( 'city', $_REQUEST ) ? sanitize_text_field( wp_unslash( $_REQUEST['city'] ) ) : '';
	$selfnamed_street    =
		array_key_exists( 'street', $_REQUEST ) ? sanitize_text_field( wp_unslash( $_REQUEST['street'] ) ) : '';
	$selfnamed_street_no =
		array_key_exists( 'streetNo', $_REQUEST ) ? sanitize_text_field( wp_unslash( $_REQUEST['streetNo'] ) ) : '';
	$selfnamed_flat_no   =
		array_key_exists( 'flatNo', $_REQUEST ) ? sanitize_text_field( wp_unslash( $_REQUEST['flatNo'] ) ) : '';
	$selfnamed_zip       = array_key_exists( 'zip', $_REQUEST ) ? sanitize_text_field( wp_unslash( $_REQUEST['zip'] ) ) : '';
	$selfnamed_vat_nr    = array_key_exists( 'vatNr', $_REQUEST ) ? sanitize_text_field( wp_unslash( $_REQUEST['vatNr'] ) ) : '';
	$selfnamed_reg_nr    = array_key_exists( 'regNr', $_REQUEST ) ? sanitize_text_field( wp_unslash( $_REQUEST['regNr'] ) ) : '';
	$selfnamed_phone     = array_key_exists( 'phone', $_REQUEST ) ? sanitize_text_field( wp_unslash( $_REQUEST['phone'] ) ) : '';
	$selfnamed_email     = array_key_exists( 'email', $_REQUEST ) ? sanitize_text_field( wp_unslash( $_REQUEST['email'] ) ) : '';

	$selfnamed_setup->set_billing_information(
		$selfnamed_name,
		$selfnamed_country,
		$selfnamed_city,
		$selfnamed_street,
		$selfnamed_street_no,
		$selfnamed_flat_no,
		$selfnamed_zip,
		$selfnamed_vat_nr,
		$selfnamed_reg_nr,
		$selfnamed_phone,
		$selfnamed_email
	);
	
	$selfnamed_admin_notice = __( 'Billing information saved successfully!', 'selfnamed-cosmetics-on-demand' );
	$selfnamed_notice_type = 'success';
}

$selfnamed_tabs = array(
	'getting-started' => array(
		'label'           => __( 'Getting Started', 'selfnamed-cosmetics-on-demand' ),
		'is_setup_needed' => false,
	),
	'products'        => array(
		'label'           => __( 'Products', 'selfnamed-cosmetics-on-demand' ),
		'is_setup_needed' => true,
	),
	'orders'          => array(
		'label'           => __( 'Orders', 'selfnamed-cosmetics-on-demand' ),
		'is_setup_needed' => true,
	),
	'delivery'        => array(
		'label'           => __( 'Delivery', 'selfnamed-cosmetics-on-demand' ),
		'is_setup_needed' => true,
	),
);

$selfnamed_default_tab = $selfnamed_setup->is_ready() ? 'products' : 'getting-started';

$selfnamed_current_tab = array_key_exists( 'tab', $_REQUEST )
				&& array_key_exists( sanitize_text_field( wp_unslash( $_REQUEST['tab'] ) ), $selfnamed_tabs )
	? sanitize_text_field( wp_unslash( $_REQUEST['tab'] ) )
	: $selfnamed_default_tab;

$selfnamed_plugin = get_plugin_data( SELFNAMED_PLUGIN_PATH ); ?>
<div class="sn-plugin">
	<div class="wrap">
		<h1><?php echo esc_html( $selfnamed_plugin['Name'] ); ?></h1>
		<?php if ( ! empty( $selfnamed_admin_notice ) ) : ?>
			<div class="notice notice-<?php echo esc_attr( $selfnamed_notice_type ); ?> is-dismissible">
				<p><?php echo esc_html( $selfnamed_admin_notice ); ?></p>
			</div>
		<?php endif; ?>
		<nav class="nav-tab-wrapper">
			<?php foreach ( $selfnamed_tabs as $selfnamed_code => $selfnamed_tab ) : ?>
				<?php if ( $selfnamed_setup->is_ready() || ! $selfnamed_tab['is_setup_needed'] ) : ?>
					<a
							href="
							<?php
							echo esc_attr(
								add_query_arg(
									array(
										'page' => $selfnamed_setup->menu_slug,
										'tab'  => $selfnamed_code,
									)
								)
							);
							?>
									"
							class="nav-tab <?php echo esc_attr( $selfnamed_code === $selfnamed_current_tab ? 'nav-tab-active' : '' ); ?>"
					>
						<?php echo esc_html( $selfnamed_tab['label'] ); ?>
					</a>
				<?php endif; ?>
			<?php endforeach; ?>
		</nav>
		<div class="tab-content <?php echo esc_attr( $selfnamed_current_tab . '_tab-content' ); ?>">
			<?php
			require_once plugin_dir_path(SELFNAMED_PLUGIN_PATH) . 'includes/admin/views/html-' . $selfnamed_current_tab
								. '.php';
			?>
		</div>
	</div>
</div>
