<?php
/**
 * This file is part of the Magebit_Selfnamed package.
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade to newer
 * versions in the future.
 *
 * Selfnamed: Cosmetics on demand extension is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * @package Magebit_Selfnamed
 */

namespace selfnamed\includes\admin;

if ( ! defined( 'ABSPATH' ) ) exit;

use Selfnamed\Model\Setup;

if ( ! class_exists( 'SN_Init_Navigation', false ) ) {
	/**
	 * Init navigation class.
	 */
	class SN_Init_Navigation {
		/**
		 * Setup model.
		 *
		 * @var Setup
		 */
		private $setup;

		/**
		 * Constructor.
		 */
		public function __construct() {
			add_action( 'admin_menu', array( $this, 'selfnamed_add_submenu' ), 1000 );

			$this->setup = new Setup();
		}

		/**
		 * Add Selfnamed submenu in WooCommerce section.
		 *
		 * @return void
		 */
		public function selfnamed_add_submenu(): void {
			add_submenu_page(
				'woocommerce',
				'Selfnamed',
				'Selfnamed',
				'manage_woocommerce',
				$this->setup->menu_slug,
				array(
					$this,
					'self_named_menu_page_callback',
				)
			);
		}

		/**
		 * Selfnamed menu page callback.
		 *
		 * @return void
		 */
		public function self_named_menu_page_callback(): void {
			include_once dirname( SELFNAMED_PLUGIN_PATH ) . '/includes/admin/class-sn-admin-page.php';
		}
	}
}

return new SN_Init_Navigation();
