<?php
/**
 * This file is part of the Magebit_Selfnamed package.
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade to newer
 * versions in the future.
 *
 * Selfnamed: Cosmetics on demand extension is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * @package Magebit_Selfnamed
 */

if ( ! class_exists( 'Selfnamed_Admin_UI', false ) ) {
    class Selfnamed_Admin_UI {
        /**
         * Render WooCommerce-like tablenav pagination block.
         *
         * @param int    $current   Current page.
         * @param int    $pages     Total pages (min 1).
         * @param int    $total     Total items.
         * @param string $base_url  Base admin URL to append paged to.
         * @param array  $options   Options: 'show_page_input' (bool) whether to render the input form.
         *
         * @return void
         */
        public static function render_pagination( $current, $pages, $total, $base_url, $options = [] ) {
            $current = (int) $current;
            $pages = (int) max( 1, $pages );
            $total = (int) $total;
            $prev = max( 1, $current - 1 );
            $next = min( $pages, $current + 1 );
            $show_input = isset( $options['show_page_input'] ) ? (bool) $options['show_page_input'] : true;
			$base_no_paged = remove_query_arg( 'paged', $base_url );
            ?>
            <div class="sn-pagination">
                <span><?php echo esc_html( number_format_i18n( $total ) ); ?> items</span>
                <div>
                    <?php if ( $current <= 1 ) : ?>
                        <span class="button disabled">«</span>
                        <span class="button disabled">‹</span>
                    <?php else : ?>
                        <a class="button" href="<?php echo esc_url( add_query_arg( 'paged', 1, $base_url ) ); ?>"><span>«</span></a>
                        <a class="button" href="<?php echo esc_url( add_query_arg( 'paged', $prev, $base_url ) ); ?>"><span>‹</span></a>
                    <?php endif; ?>
                    <?php if ( $show_input ) : ?>
						<div>
							<input type="text" value="<?php echo esc_attr( (string) $current ); ?>" size="1" data-base="<?php echo esc_attr( (string) $base_no_paged ); ?>" 
                                onchange="window.location.href='<?php echo esc_url( $base_url ); ?>' + '&paged=' + Math.min(parseInt(this.value), <?php echo esc_attr( (string) $pages ); ?>)" />
							<span> of <span class="total-pages"><?php echo esc_html( (string) $pages ); ?></span></span>
						</div>
                    <?php else : ?>
                        <div>
                            <span>
                                <?php echo esc_html( (string) $current ); ?> of 
                                <span class="total-pages"><?php echo esc_html( (string) $pages ); ?></span>
                            </span>
                        </div>
                    <?php endif; ?>
                    <?php if ( $current >= $pages ) : ?>
                        <span class="button disabled">›</span>
                        <span class="button disabled">»</span>
                    <?php else : ?>
                        <a class="button" href="<?php echo esc_url( add_query_arg( 'paged', $next, $base_url ) ); ?>"><span>›</span></a>
                        <a class="button" href="<?php echo esc_url( add_query_arg( 'paged', $pages, $base_url ) ); ?>"><span>»</span></a>
                    <?php endif; ?>
                </div>
            </div>
            <?php
        }

        /**
         * Render a small Items per page form compatible with our refresh handler.
         *
         * @param int   $current_page Current page to preserve on submit.
         * @param int   $per_page     Current per-page value.
         * @param array $args         Options: 'options' (array of ints), 'class' (string), 'style' (string), 'nonce_action' (string), 'submit_label' (string).
         *
         * @return void
         */
        public static function render_items_per_page( $per_page, $args = [] ) {
            $options = isset( $args['options'] ) && is_array( $args['options'] ) ? $args['options'] : [ 20, 50 ];
            ?>
            <form method="post">
                <?php wp_nonce_field( 'selfnamed-orders-per-page', 'selfnamed_nonce' ); ?>
                <label for="per_page">Items per page</label>
                <select id="per_page" name="per_page" onchange="HTMLFormElement.prototype.submit.call(this.form)">
                    <?php foreach ( $options as $option ) : ?>
                        <option value="<?php echo (int) $option; ?>" <?php selected( (int) $per_page, (int) $option ); ?>>
                            <?php echo (int) $option; ?>
                        </option>
                    <?php endforeach; ?>
                </select>
            </form>
            <?php
        }
    }
}


