<?php
/**
 * This file is part of the Magebit_Selfnamed package.
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade to newer
 * versions in the future.
 *
 * Selfnamed: Cosmetics on demand extension is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * @package Magebit_Selfnamed
 */

namespace selfnamed\includes\admin;

if ( ! defined( 'ABSPATH' ) ) exit;

if ( ! class_exists( 'SN_Admin_Assets', false ) ) {
	/**
	 * Admin assets class.
	 */
	class SN_Admin_Assets {
		/**
		 * Version.
		 *
		 * @var float
		 */
		private $version;

		/**
		 * Constructor.
		 */
		public function __construct() {
			$this->version = SELFNAMED_VERSION;
			add_action( 'admin_enqueue_scripts', array( $this, 'register_assets' ) );
		}

		/**
		 * Register assets such as styles and scripts.
		 *
		 * @return void
		 */
		public function register_assets(): void {
			$this->register_styles();
			$this->register_scripts();
		}

		/**
		 * Register javascript scripts.
		 *
		 * @return void
		 */
		public function register_scripts(): void {
			wp_register_script(
				'selfnamed_script_admin',
				plugin_dir_url( SELFNAMED_PLUGIN_PATH ) . 'assets/js/admin/admin.js',
				array(),
				$this->version
			);
			wp_register_script(
				'selfnamed_script_admin_product',
				plugin_dir_url( SELFNAMED_PLUGIN_PATH ) . 'assets/js/admin/product.js',
				array(),
				$this->version
			);			

			wp_enqueue_script( 'selfnamed_script_admin' );	
			wp_enqueue_script( 'selfnamed_script_admin_product' );
			
			wp_localize_script(
				'selfnamed_script_admin_product',
				'sn_admin_product',
				array(
					'ajax_url'          => admin_url( 'admin-ajax.php' ),
					'sync_all_nonce'    => wp_create_nonce( 'sn_sync_all_products' ),
					'batch_info_nonce'  => wp_create_nonce( 'sn_get_sync_batch_info' ),
					'sync_all_action'   => 'sn_sync_all_products',
					'batch_info_action' => 'sn_get_sync_batch_info',
				)
			);
		}

		/**
		 * Register CSS styles.
		 *
		 * @return void
		 */
		public function register_styles(): void {
			wp_register_style(
				'selfnamed_style_admin_main',
				plugin_dir_url( SELFNAMED_PLUGIN_PATH ) . 'assets/css/admin/style.css',
				array(),
				$this->version
			);
			wp_register_style(
				'selfnamed_style_admin_product_sync',
				plugin_dir_url( SELFNAMED_PLUGIN_PATH ) . 'assets/css/admin/product-sync.css',
				array(),
				$this->version
			);

			wp_enqueue_style( 'selfnamed_style_admin_main' );

			wp_enqueue_style( 'selfnamed_style_admin_product_sync' );
		}
	}
}

return new SN_Admin_Assets();
