<?php
/**
 * This file is part of the Magebit_Selfnamed package.
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade to newer
 * versions in the future.
 *
 * Selfnamed: Cosmetics on demand extension is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * @package Magebit_Selfnamed
 */

if ( ! defined( 'ABSPATH' ) ) exit;

spl_autoload_register( 'selfnamed_autoloader' );

/**
 * Convert class path to match the actual path for the class
 *
 * @param string $class_path The class path.
 *
 * @return string
 * @example From "Selfnamed\Model\Selfnamed_Shipping_Method" to "Selfnamed\Model\class-selfnamed-shipping-method"
 */
function selfnamed_convert_class_path( string $class_path ): string {
	$path            = explode( '\\', $class_path );
	$class_name      = strtolower( end( $path ) );
	$class_name      = str_replace( '_', '-', $class_name );
	$real_class_name = 'class-' . $class_name;

	return implode( '\\', array_slice( $path, 0, - 1 ) ) . '\\' . $real_class_name;
}

/**
 * Autoload the class when calling in file.
 *
 * @param string $class_path The class path.
 *
 * @return void
 */
function selfnamed_autoloader( string $class_path ) {
	if ( false !== strpos( $class_path, 'Selfnamed' ) ) {
		$classes_dir = realpath( plugin_dir_path( __FILE__ ) ) . DIRECTORY_SEPARATOR . 'src' . DIRECTORY_SEPARATOR;
		$class_file  = str_replace( '\\', DIRECTORY_SEPARATOR, selfnamed_convert_class_path( $class_path ) ) . '.php';
		$class_file  = substr( $class_file, strlen( 'Selfnamed' . DIRECTORY_SEPARATOR ) );
		require_once $classes_dir . $class_file;
	}
}
