/*
 * Selfnamed: Cosmetics on demand extension is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/* global sn_admin_product */
(function($) {
    function syncAllProducts(callback) {
        $.ajax({
            url: sn_admin_product.ajax_url,
            data: {
                action: sn_admin_product.batch_info_action,
                selfnamed_nonce: sn_admin_product.batch_info_nonce
            },
            type: 'POST'
        }).done(function (batchInfoResponse) {
            try {
                if (!batchInfoResponse.success) {
                    callback(false);
                    console.warn(batchInfoResponse);

                    return;
                }

                var pages = batchInfoResponse.data.pages;
                var curPage = 1;

                var proceedOrFinish = function () {
                    if (curPage <= pages) {
                        $.ajax({
                            url: sn_admin_product.ajax_url,
                            data: {
                                action: sn_admin_product.sync_all_action,
                                selfnamed_nonce: sn_admin_product.sync_all_nonce,
                                page: curPage++
                            },
                            type: 'POST'
                        }).done(function (syncResponse) {
                            if (syncResponse.success) {
                                proceedOrFinish();
                            } else {
                                callback(false);
                                console.warn(syncResponse);
                            }
                        }).fail(function (error) {
                            callback(false);
                            console.warn(error);
                        });
                    } else {
                        callback(true);
                    }
                }

                proceedOrFinish();
            } catch (e) {
                callback(false);
                console.warn(e);
            }
        }).fail(function (error) {
            callback(false);
            console.warn(error);
        });
    }

    $(function() {
        var $confirmWindow = $('#sync_all_products_confirmation');
        var $loadingWindow = $('#sync_all_products_loading');

        var openModal = function () {
            $confirmWindow.addClass('_active');
        }

        var closeModal = function () {
            $confirmWindow.removeClass('_active');
        }

        var openLoader = function () {
            $loadingWindow.addClass('_active');
        }

        var closeLoader = function () {
            $loadingWindow.removeClass('_active');
        }

        $(document.body).on(
            'click.syncAllProducts',
            '#sync_all_products',
            openModal
        );

        $(document.body).on(
            'click.syncAllProducts_cancel',
            '#sync-all-decline, #sync_all_products_confirmation .overlay',
            closeModal
        );

        $(document.body).on(
            'click.syncAllProducts_confirm',
            '#sync-all-confirm',
            function () {
                closeModal();
                openLoader();
                syncAllProducts(function (success) {
                    if (success) {
                        window.location.reload();
                    } else {
                        // TODO: show error
                        closeLoader();
                    }
                });
            }
        )
    });
})(window.jQuery)
