window.sn_admin = {};
window.sn_admin.bulk_actions = function(formId) {	
    var self = this;
    this.$form = jQuery(formId);

    var submitted = false;
    var buttons = [];
    var checkedCounter = this.$form.find('#sn-select-all span');
    var masterCheckbox = this.$form.find('#sn-select-all input[type="checkbox"]');
    var checkboxes = this.$form.find('input[type="checkbox"][name="order_ids[]"]');

    var init = function() {
        self.$form.append('<input type="hidden" name="action" value="" />');
        self.$form.append('<input type="hidden" name="selfnamed_nonce" value="" />');

		checkboxes.on('change', updateCounterAndMaster);
		masterCheckbox.on('change', function() {
			checkboxes.prop('checked', masterCheckbox.prop('checked'));
			updateCounterAndMaster();
		});
		updateCounterAndMaster();
	}
    
    var updateCounterAndMaster = function() {
        var total = checkboxes.length;
        var selected = 0;
        for (var i = 0; i < total; i++) { if ( checkboxes[i].checked ) selected++; }
        checkedCounter.text(selected);
        masterCheckbox.prop('checked', (selected === total && total > 0));
        masterCheckbox.prop('indeterminate', (selected > 0 && selected < total));
        if (selected > 0) {
            buttons.forEach(function(button) {
                button.prop('disabled', false);
            });
        } else {
            buttons.forEach(function(button) {
                button.prop('disabled', true);
            });
        }
    };

    this.submitBulkAction = function(action, nonce) {
        var nonceInput = self.$form.find('input[name="selfnamed_nonce"]');
		nonceInput.val(nonce);
		var actionInput = self.$form.find('input[name="action"]');
		actionInput.val(action);
		if ( submitted ) {
			return;
		}		
        submitted = true;
        self.$form.submit();
	}

    this.initBulkActionButton = function(selector, action, nonce) {
		var button = jQuery(selector);
        buttons.push(button);
		button.on('click', function() {
			sn_admin_form.submitBulkAction(action, nonce);
		});
        updateCounterAndMaster();
	}
	
	init();
}