<?php
/**
 * Selektable Uninstall
 *
 * Removes all plugin data when uninstalled via the WordPress admin.
 */

if (!defined('WP_UNINSTALL_PLUGIN')) {
    die;
}

// Remove plugin options
delete_option('selektable_integrations');
delete_option('selektable_app_url');
delete_option('selektable_db_version');

// Remove legacy options (pre-1.2.0)
delete_option('selektable_widget_id');
delete_option('selektable_button_placement');
delete_option('selektable_button_text');
delete_option('selektable_button_class');
delete_option('selektable_enable_all');
delete_option('selektable_enabled_categories');
delete_option('selektable_enabled_tags');

// Remove per-product meta
delete_post_meta_by_key('_selektable_status');
delete_post_meta_by_key('_selektable_override_image_id');
