(function($) {
    'use strict';
    
    /**
     * Initialize Select2 on multi-select fields
     */
    function initSelect2() {
        if ( ! $('.select-2-allowed select[multiple]').length ) {
            return;
        }

        $('.select-2-allowed').each(function(item) {
            var $container = $(this);
            var $select = $container.find('select[multiple]');
            let $current__indexed = $select.attr('data-select2-indexed') ?? '';

            if ( $current__indexed.length && ! $select.hasClass('select2-hidden-accessible') ) {
                var placeholder = $select.attr('data-multiple-placeholder') || '';

                jQuery('select[data-select2-indexed="'+ $current__indexed +'"]').select2({
                    placeholder: placeholder,
                    allowClear: true,
                    width: '100%',
                });

            }
        });
    }

    // Initialize on document ready
    $(document).ready(function() {
        setTimeout(initSelect2, 500);

        // $('body').on('click', '.select2-selection', function(e){
        //     e.stopPropagation();

        //     const $self_container = $(this);
        //     const $self_selection = $self_container.find('.select2-selection');
        //     const $self_dropdown = $self_container.find('.select2-dropdown');
        //     const $self_searchField = $self_container.find('.select2-search__field');

        //     console.log($self_container, $self_selection, $self_dropdown, $self_searchField);

        //     $('.select2-selection').not(this).removeClass('active');
        //     $('.select2-dropdown').not($self_dropdown).removeClass('active');

        //     $self_selection.toggleClass('active');
        //     $self_dropdown.toggleClass('active');

        //     if ($self_dropdown.hasClass('active')) {
        //         $self_searchField.focus();
        //     }

        // });
    });

    // Reinitialize for AJAX-loaded forms
    $(document).on('elementor/popup/show', function() {
        setTimeout(initSelect2, 500);
    });




})(jQuery);