jQuery(document).ready(function($) {
    // Function to refresh backup list
    function refreshBackupList() {
        $.ajax({
            url: seincBackup.ajax_url,
            type: 'POST',
            data: {
                action: 'seinc_get_backup_list',
                nonce: seincBackup.list_nonce
            },
            success: function(response) {
                if (response.success) {
                    $('.wp-list-table tbody').html(response.data);
                }
            }
        });
    }

    // Handle form submission
    $('#backup-form').on('submit', function(e) {
        e.preventDefault();
        
        const createBackupBtn = $('input[name="create_backup"]');
        const savePathBtn = $('input[name="save_path"]');
        
        // Handle Save Path
        if (savePathBtn.is(':focus')) {
            const backupPath = $('#backup_path').val();
            if (!backupPath) {
                alert(seincBackup.i18n.emptyPath);
                return;
            }

            savePathBtn.prop('disabled', true);

            $.ajax({
                url: seincBackup.ajax_url,
                type: 'POST',
                data: {
                    action: 'seinc_backup_save_path',
                    nonce: $('#save_path_nonce').val(),
                    backup_path: backupPath
                },
                success: function(response) {
                    if (response.success) {
                        // Show success message in green bar
                        const successMessage = $('<div class="notice notice-success is-dismissible"><p>' + response.data + '</p></div>');
                        $('.wp-list-table').before(successMessage);
                        refreshBackupList();
                    } else {
                        alert(response.data || seincBackup.i18n.unknownError);
                    }
                    savePathBtn.prop('disabled', false);
                },
                error: function() {
                    alert(seincBackup.i18n.unknownError);
                    savePathBtn.prop('disabled', false);
                }
            });
            return;
        }

        // Handle Create Backup
        if (createBackupBtn.is(':focus')) {
            createBackupBtn.prop('disabled', true);

            $.ajax({
                url: seincBackup.ajax_url,
                type: 'POST',
                data: {
                    action: 'seinc_backup_start',
                    nonce: seincBackup.backup_nonce
                },
                success: function(response) {
                    if (response.success) {
                        // Show success message in green bar
                        const successMessage = $('<div class="notice notice-success is-dismissible"><p>' + seincBackup.i18n.backupCompleted + '</p></div>');
                        $('.wp-list-table').before(successMessage);
                        
                        // Refresh the backup list
                        refreshBackupList();
                        
                        // Enable the button
                        createBackupBtn.prop('disabled', false);
                    } else {
                        createBackupBtn.prop('disabled', false);
                        alert(response.data || seincBackup.i18n.unknownError);
                    }
                },
                error: function(xhr, status, error) {
                    createBackupBtn.prop('disabled', false);
                    console.error('Backup error:', error);
                    alert(seincBackup.i18n.unknownError);
                }
            });
        }
    });

    // Handle directory browsing
    $('#browse_button').on('click', function() {
        $('#directory_browser').show();
        updateDirectoryList('/');
    });

    $('#cancel_browse').on('click', function() {
        $('#directory_browser').hide();
    });

    $('#select_directory').on('click', function() {
        const selectedPath = $('#current_path').text();
        $('#backup_path').val(selectedPath);
        $('#directory_browser').hide();
    });

    function updateDirectoryList(path) {
        $('#directory_list').html('<li>Loading...</li>');
        $('#current_path').text(path);

        $.ajax({
            url: seincBackup.ajax_url,
            type: 'POST',
            data: {
                action: 'seinc_backup_browse',
                nonce: seincBackup.nonce,
                dir: path
            },
            success: function(response) {
                if (response.success) {
                    $('#directory_list').empty();
                    $('#current_path').text(response.data.current);
                    
                    // Add parent directory option if not at root
                    if (path !== '/') {
                        $('#directory_list').append(
                            $('<li>').append(
                                $('<a>')
                                    .text('..')
                                    .attr('href', '#')
                                    .addClass('directory-link')
                                    .data('path', response.data.parent)
                            )
                        );
                    }
                    
                    // Add directories
                    if (response.data.directories && response.data.directories.length > 0) {
                        response.data.directories.forEach(function(dir) {
                            const dirClass = dir.writable ? 'directory-link' : 'directory-link read-only';
                            $('#directory_list').append(
                                $('<li>').append(
                                    $('<a>')
                                        .text(dir.name)
                                        .attr('href', '#')
                                        .addClass(dirClass)
                                        .data('path', dir.path)
                                )
                            );
                        });
                    } else {
                        $('#directory_list').append('<li>No subdirectories found</li>');
                    }
                } else {
                    $('#directory_list').html('<li>Error: ' + (response.data || 'Failed to load directory list') + '</li>');
                }
            },
            error: function() {
                $('#directory_list').html('<li>Error loading directory list</li>');
            }
        });
    }

    // Handle directory navigation
    $('#directory_list').on('click', '.directory-link', function(e) {
        e.preventDefault();
        const path = $(this).data('path');
        if (path) {
            updateDirectoryList(path);
        }
    });

    // Handle backup deletion
    $('.wp-list-table').on('click', '.delete-backup', function() {
        if (!confirm(seincBackup.i18n.confirmDelete)) {
            return;
        }

        const button = $(this);
        const file = button.data('file');

        button.prop('disabled', true);

        $.ajax({
            url: seincBackup.ajax_url,
            type: 'POST',
            data: {
                action: 'seinc_backup_delete',
                nonce: seincBackup.delete_nonce,
                file: file
            },
            success: function(response) {
                if (response.success) {
                    refreshBackupList();
                } else {
                    alert(response.data || seincBackup.i18n.unknownError);
                    button.prop('disabled', false);
                }
            },
            error: function() {
                alert(seincBackup.i18n.unknownError);
                button.prop('disabled', false);
            }
        });
    });
});
