<form action="" method="post" class="woo-seedtrace-admin">
    <div id="settings-panel">
        <div class="section-company">
            <div class="left-side">
                <ul>
                    <li><a class="change-table active" data-table="settings-table"><i class="fas fa-align-left"></i> Main Settings</a></li>
                    <li><a class="change-table" data-table="instruction-table"><i class="fas fa-question-circle"></i> Use Instructions</a></li>
                    <li><a class="change-table" data-table="system-report"><i class="fas fa-shield-alt"></i> System Report</a></li>
                    <li><a class="support-item" href="https://seedtrace.org" target="_blank"><i class="fas fa-life-ring"></i> Plugin Support</a></li>
                </ul>
            </div>
            <div class="right-side">
                <a href="https://seedtrace.org" target="_blank"><img src="<?php echo esc_attr( SEEDTRACE_PLUGIN_PATH . '/templates/assets/img/seedtrace_logo.png' ); ?>" alt=""></a>
            </div>
        </div>
        <div class="select-table" id="settings-table">
            <div class="section_data">
                <div class="title">API Settings</div>
                <div class="head_items">
                    <div class="item-table">API KEY: <a href="#" data-tooltip="You can find your API key in your seedtrace admin panel" class="help-icon clicktips"><i class="fas fa-question-circle"></i></a></div>
                    <div class="item-table">WORK MODE: <a href="#" data-tooltip="Learn more about widget placement in Use Instructions" class="help-icon clicktips"><i class="fas fa-question-circle"></i></a></div>
                </div>
                <div class="items-list">
                    <div class="item-content">
                        <div class="item-table"><input type="text" name="seedtrace[api_key]" value="<?php if ( isset( $settings ) && isset( $settings['api_key'] ) ) {
								echo esc_attr( $settings['api_key'] );
							} ?>"></div>
                        <div class="item-table">
                            <select name="seedtrace[mode]" class="select">
                                <option value="after_cart" <?php if ( isset( $settings['mode'] ) && $settings['mode'] == 'after_cart' ) {
									echo esc_attr( 'selected' );
								} ?>>After Add to Cart
                                </option>
                                <option value="shortcode" <?php if ( isset( $settings['mode'] ) && $settings['mode'] == 'shortcode' ) {
									echo esc_attr( 'selected' );
								} ?>>Shortcode Only
                                </option>
                            </select>
                        </div>
                    </div>
                </div>
            </div>
            <div class="section_data">
                <div class="title">Select product matching to API</div>
				<?php if ( is_plugin_active( 'woocommerce/woocommerce.php' ) ) { ?>
                    <div class="head_items" style="<?php if ( isset( $settings['product'] ) && is_array($settings['product']) && count( $settings['product'] ) > 0 ) {
					} else {
						echo esc_attr( "display: none" );
					} ?>">
                        <div class="number_element">#</div>
                        <div class="item-table">Product <a href="#" data-tooltip="Select WooCommerce product where is to show block with API Product" class="help-icon clicktips"><i class="fas fa-question-circle"></i></a></div>
                        <div class="item-table">API Product <a href="#" data-tooltip="Select API Product which will be shown on selected WordPress product" class="help-icon clicktips"><i class="fas fa-question-circle"></i></a></div>
                    </div>
                    <div class="items-list">
						<?php if ( $products && isset( $settings['product'] ) && is_array($settings['product']) && count( $settings['product'] ) > 0 ) {
							$i = 1;
							foreach ( $settings['product'] as $item => $product_id ) { ?>
                                <div class="item-content">
                                    <div class="number_element"><?php echo (int) $i; ?></div>
                                    <div class="item-table">
                                        <select name="seedtrace[product][]" class="select" data-search="true">
                                            <option value="0">No Product</option>
											<?php foreach ( $products as $product ) { ?>
                                                <option value="<?php echo esc_html( $product->ID ) ?>" <?php if ( $product->ID == $product_id ) {
													echo esc_attr( 'selected' );
												} ?>><?php echo esc_html( $product->post_title ) ?></option>
											<?php } ?>
                                        </select>
                                    </div>
                                    <div class="item-table">
                                        <select name="seedtrace[api_product][]" class="select" data-search="true">
                                            <option value='0'>No Product</option>
											<?php if ( isset( $api_products['data']['companyProducts']['edges'] ) ) {
												foreach ( $api_products['data']['companyProducts']['edges'] as $number => $product ) { ?>
                                                    <option value="<?php echo esc_attr( $product['node']['id'] ) ?>" <?php if ( isset($settings['api_product'][ $item ]) && $product['node']['id'] == $settings['api_product'][ $item ] ) {
														echo esc_attr( 'selected' );
													} ?>><?php echo esc_html( isset($product['node']['title']) ? $product['node']['title'] : '' ); ?></option>
												<?php }
											} ?>
                                        </select>
                                    </div>
                                    <div class="delete_item"><i class="fas fa-trash"></i></div>
                                </div>
								<?php $i ++;
							}
						} else { ?>
                            <div class="item-content" style="display: none">
                                <div class="number_element">1</div>
                                <div class="item-table">
                                    <select name="seedtrace[product][]" class="select" data-search="true">
                                        <option value="0">No Product</option>
										<?php foreach ( $products as $product ) { ?>
                                            <option value="<?php echo esc_attr( $product->ID ) ?>"><?php echo esc_html( $product->post_title ) ?></option>
										<?php } ?>
                                    </select>
                                </div>
                                <div class="item-table">
                                    <select name="seedtrace[api_product][]" class="select" data-search="true">
                                        <option value='0'>No Product</option>
										<?php if ( isset( $api_products['data']['companyProducts']['edges'] ) ) {
											foreach ( $api_products['data']['companyProducts']['edges'] as $number => $product ) { ?>
                                                <option value="<?php echo esc_attr( $product['node']['slug'] ) ?>"><?php echo esc_html( $product['node']['title'] ) ?></option>
											<?php }
										} ?>
                                    </select>
                                </div>
                                <div class="delete_item"><i class="fas fa-trash"></i></div>
                            </div>
						<?php } ?>
                        <button class="button button-primary button-large add-item" type="button"><i class="fas fa-plus-square"></i> Add new Item</button>
                    </div>
				<?php } else { ?>
                    <div class="dependency-warning"><i class="fas fa-question-circle"></i> Install WooCommerce for open all functions</div>
				<?php } ?>
            </div>
            <button class="button button-primary button-large" id="save-settings" type="submit">Save settings</button>
        </div>
        <div class="select-table" id="instruction-table" style="display: none">
            <div class="section_data">
                <div class="title">How Use Shortcodes</div>
                <p>If you select the display mode only after the add to cart button, you should take into account that the shortcodes added to the pages earlier will also work. If you enable the "Only shortcode" mode, then the script will not be displayed under the "Add to cart" button, but only in places where the shortcode is added.</p>
                <p>There are 2 methods for calling the shortcode. The first is for insertion in the description of the product text, and the second is anywhere in the product page template.</p>
                <div class="sub-title">Using shortcode in description:</div>
                <p><code>[seedtrace]</code> or <code>[seedtrace product-id="test"]</code></p>
                <div class="sub-title">Using shortcode in theme template (PHP):</div>
                <p><code>do_shortcode("[seedtrace]")</code> or <code>do_shortcode('[seedtrace product-id="test"]')</code></p>
                <p><b>product-id</b> - is ID from API Product which will be shown</p>
            </div>
        </div>
        <div class="select-table" id="system-report" style="display: none">
            <div class="section_data">
                <div class="alert-help">
                    <i class="fas fa-question-circle"></i> <?php echo esc_html__( 'The following is a system report containing useful technical information for troubleshooting issues. If you need further help after viewing the report, do the screenshots of this page and send it to our Support.', 'wpm-core' ) ?>
                </div>
                <table class="status-table" cellpadding="0" cellspacing="0">
                    <thead>
                    <tr>
                        <th colspan="2"><?php echo esc_html__( 'WordPress', 'wpm-core' ); ?></th>
                    </tr>
                    </thead>
                    <tbody>
                    <tr>
                        <td><?php echo esc_html__( 'Home URL', 'wpm-core' ); ?></td>
                        <td><?php echo esc_html( get_home_url() ); ?></td>
                    </tr>
                    <tr>
                        <td><?php echo esc_html__( 'Site URL', 'wpm-core' ); ?></td>
                        <td><?php echo esc_html( get_site_url() ); ?></td>
                    </tr>
                    <tr>
                        <td><?php echo esc_html__( 'REST API Base URL', 'wpm-core' ); ?></td>
                        <td><?php echo esc_html( rest_url() ); ?></td>
                    </tr>
                    <tr>
                        <td><?php echo esc_html__( 'WordPress Version', 'wpm-core' ); ?></td>
                        <td><?php echo esc_html( $wp_version ); ?></td>
                    </tr>
                    <tr>
                        <td><?php echo esc_html__( 'WordPress Memory Limit', 'wpm-core' ); ?></td>
                        <td><?php echo esc_html( WP_MEMORY_LIMIT ); ?></td>
                    </tr>
                    <tr>
                        <td><?php echo esc_html__( 'WordPress Debug Mode', 'wpm-core' ); ?></td>
                        <td><?php echo esc_html( WP_DEBUG ? 'Yes' : 'No' ); ?></td>
                    </tr>
                    <tr>
                        <td><?php echo esc_html__( 'WordPress Debug Log', 'wpm-core' ); ?></td>
                        <td><?php echo esc_html( WP_DEBUG_LOG ? __( 'Yes', 'wpm-core' ) : __( 'No', 'wpm-core' ) ); ?></td>
                    </tr>
                    <tr>
                        <td><?php echo esc_html__( 'WordPress Script Debug Mode', 'wpm-core' ); ?></td>
                        <td><?php echo esc_html( SCRIPT_DEBUG ? __( 'Yes', 'wpm-core' ) : __( 'No', 'wpm-core' ) ); ?></td>
                    </tr>
                    <tr>
                        <td><?php echo esc_html__( 'WordPress Cron', 'wpm-core' ); ?></td>
                        <td><?php echo esc_html( defined( 'DISABLE_WP_CRON' ) && DISABLE_WP_CRON ? __( 'Yes', 'wpm-core' ) : __( 'No', 'wpm-core' ) ); ?></td>
                    </tr>
                    <tr>
                        <td><?php echo esc_html__( 'WordPress Alternate Cron', 'wpm-core' ); ?></td>
                        <td><?php echo esc_html( defined( 'ALTERNATE_WP_CRON' ) && ALTERNATE_WP_CRON ? __( 'Yes', 'wpm-core' ) : __( 'No', 'wpm-core' ) ); ?></td>
                    </tr>
                    </tbody>
                </table>
                <table class="status-table" cellpadding="0" cellspacing="0">
                    <thead>
                    <tr>
                        <th colspan="2"><?php echo esc_html__( 'Web Server', 'wpm-core' ); ?></th>
                    </tr>
                    </thead>
                    <tbody>
                    <tr>
                        <td><?php echo esc_html__( 'Software', 'wpm-core' ); ?></td>
                        <td><?php echo esc_html( $_SERVER['SERVER_SOFTWARE'] ); ?></td>
                    </tr>
                    <tr>
                        <td><?php echo esc_html__( 'Port', 'wpm-core' ); ?></td>
                        <td><?php echo esc_html( $_SERVER['SERVER_PORT'] ); ?></td>
                    </tr>
                    <tr>
                        <td><?php echo esc_html__( 'Document Root', 'wpm-core' ); ?></td>
                        <td><?php echo esc_html( $_SERVER['DOCUMENT_ROOT'] ); ?></td>
                    </tr>
                    </tbody>
                </table>
                <table class="status-table" cellpadding="0" cellspacing="0">
                    <thead>
                    <tr>
                        <th colspan="2"><?php echo esc_html__( 'PHP', 'wpm-core' ); ?></th>
                    </tr>
                    </thead>
                    <tbody>
                    <tr>
                        <td><?php echo esc_html__( 'Version', 'wpm-core' ); ?></td>
                        <td><?php echo esc_html( phpversion() ); ?></td>
                    </tr>
                    <tr>
                        <td><?php echo esc_html__( 'Memory Limit (memory_limit)', 'wpm-core' ); ?></td>
                        <td><?php echo esc_html( ini_get( 'memory_limit' ) ); ?></td>
                    </tr>
                    <tr>
                        <td><?php echo esc_html__( 'Maximum Execution Time (max_execution_time)', 'wpm-core' ); ?></td>
                        <td><?php echo esc_html( ini_get( 'max_execution_time' ) ); ?></td>
                    </tr>
                    <tr>
                        <td><?php echo esc_html__( 'Maximum File Upload Size (upload_max_filesize)', 'wpm-core' ); ?></td>
                        <td><?php echo esc_html( ini_get( 'upload_max_filesize' ) ); ?></td>
                    </tr>
                    <tr>
                        <td><?php echo esc_html__( 'Maximum File Uploads (max_file_uploads)', 'wpm-core' ); ?></td>
                        <td><?php echo esc_html( ini_get( 'max_file_uploads' ) ); ?></td>
                    </tr>
                    <tr>
                        <td><?php echo esc_html__( 'Maximum Post Size (post_max_size)', 'wpm-core' ); ?></td>
                        <td><?php echo esc_html( ini_get( 'post_max_size' ) ); ?></td>
                    </tr>
                    <tr>
                        <td><?php echo esc_html__( 'Maximum Input Variables (max_input_vars)', 'wpm-core' ); ?></td>
                        <td><?php echo esc_html( ini_get( 'max_input_vars' ) ); ?></td>
                    </tr>
                    <tr>
                        <td><?php echo esc_html__( 'cURL Enabled', 'wpm-core' ); ?></td>
                        <td><?php $curl = curl_version();
							if ( isset( $curl['version'] ) ) {
								echo esc_html( "Yes (version {$curl['version']})" );
							} else {
								echo esc_html( "No" );
							} ?></td>
                    </tr>
                    <tr>
                        <td><?php echo esc_html__( 'Mcrypt Enabled', 'wpm-core' ); ?></td>
                        <td><?php echo esc_html( function_exists( 'mcrypt_encrypt' ) ? 'Yes' : 'No' ); ?></td>
                    </tr>
                    <tr>
                        <td><?php echo esc_html__( 'Mbstring Enabled', 'wpm-core' ); ?></td>
                        <td><?php echo esc_html( function_exists( 'mb_strlen' ) ? 'Yes' : 'No' ); ?></td>
                    </tr>
                    <tr>
                        <td><?php echo esc_html__( 'Loaded Extensions', 'wpm-core' ); ?></td>
                        <td><?php echo esc_html( implode( ', ', get_loaded_extensions() ) ); ?></td>
                    </tr>
                    </tbody>
                </table>
                <table class="status-table" cellpadding="0" cellspacing="0">
                    <thead>
                    <tr>
                        <th colspan="2"><?php echo esc_html__( 'Database Server', 'wpm-core' ); ?></th>
                    </tr>
                    </thead>
                    <tbody>
                    <tr>
                        <td><?php echo esc_html__( 'Database Character Set', 'wpm-core' ); ?></td>
                        <td><?php echo esc_html( $wpdb->get_var( 'SELECT @@character_set_database' ) ); ?></td>
                    </tr>
                    <tr>
                        <td><?php echo esc_html__( 'Database Collation', 'wpm-core' ); ?></td>
                        <td><?php echo esc_html( $wpdb->get_var( 'SELECT @@collation_database' ) ); ?></td>
                    </tr>
                    </tbody>
                </table>
                <table class="status-table" cellpadding="0" cellspacing="0">
                    <thead>
                    <tr>
                        <th colspan="2"><?php echo esc_html__( 'Date and Time', 'wpm-core' ); ?></th>
                    </tr>
                    </thead>
                    <tbody>
                    <tr>
                        <td><?php echo esc_html__( 'WordPress (Local) Timezone', 'wpm-core' ); ?></td>
                        <td><?php echo esc_html( get_option( 'timezone_string' ) ); ?></td>
                    </tr>
                    <tr>
                        <td><?php echo esc_html__( 'MySQL (UTC)', 'wpm-core' ); ?></td>
                        <td><?php echo esc_html( $wpdb->get_var( 'SELECT utc_timestamp()' ) ); ?></td>
                    </tr>
                    <tr>
                        <td><?php echo esc_html__( 'MySQL (Local)', 'wpm-core' ); ?></td>
                        <td><?php echo esc_html( date( "F j, Y, g:i a", strtotime( $wpdb->get_var( 'SELECT utc_timestamp()' ) ) ) ); ?></td>
                    </tr>
                    <tr>
                        <td><?php echo esc_html__( 'PHP (UTC)', 'wpm-core' ); ?></td>
                        <td><?php echo esc_html( date( 'Y-m-d H:i:s' ) ); ?></td>
                    </tr>
                    <tr>
                        <td><?php echo esc_html__( 'PHP (Local)', 'wpm-core' ); ?></td>
                        <td><?php echo esc_html( date( "F j, Y, g:i a" ) ); ?></td>
                    </tr>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</form>
