<?php
/**
 * SecurelyWP Recovery Codes Handler
 *
 * Handles generation and verification of recovery codes for 2FA.
 *
 * @package SecurelyWP
 * @since 1.0.7
 */

if (!defined('ABSPATH')) {
    exit;
}

/**
 * Generate recovery codes for a user.
 *
 * @return array Array of recovery codes.
 */
function securelywp_generate_recovery_codes() {
    $codes = [];
    for ($i = 0; $i < 8; $i++) {
        $codes[] = wp_generate_password(12, false, false);
    }
    return $codes;
}

/**
 * Verify a recovery code.
 *
 * @param int $user_id User ID.
 * @param string $code Code to verify.
 * @return bool True if valid, false otherwise.
 */
function securelywp_verify_recovery_code($user_id, $code) {
    $user_2fa_options = get_user_meta($user_id, 'securelywp_2fa_user_options', true) ?: [];
    $recovery_codes = !empty($user_2fa_options['recovery_codes']) ? $user_2fa_options['recovery_codes'] : [];
    $index = array_search($code, $recovery_codes, true);
    if ($index !== false) {
        unset($recovery_codes[$index]);
        $user_2fa_options['recovery_codes'] = array_values($recovery_codes);
        update_user_meta($user_id, 'securelywp_2fa_user_options', $user_2fa_options);
        return true;
    }
    return false;
}