<?php

/**
 * @link              https://ideastocode.com
 * @since             1.0.0
 * @package           Secure Login Authorization
 *
 * @wordpress-plugin
 * Plugin Name:       Secure Login Authorization
 * Plugin URI:        https://ideastocode.com/plugins/wp-secure-login-authorization/
 * Description:       This plugin prevents unauthorized logins and sets time limits for users by using app authentication.
 * Version:           1.0.0
 * Author:            ideasToCode
 * Author URI:        http://ideastocode.com/
 * License:           GPL-2.0+
 * License URI:       http://www.gnu.org/licenses/gpl-2.0.txt
 * Text Domain:       secure-login-authorization
 * Domain Path:       /languages
 */

// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	die;
}

define( 'ITC_SLAWP_SECURE_LOGIN_AUTHORIZATION_VERSION', '1.0.0' );
if ( ! defined( 'ITC_SLAWP_SECURE_LOGIN_AUTHORIZATION_BASENAME' ) ) {
	define( 'ITC_SLAWP_SECURE_LOGIN_AUTHORIZATION_BASENAME', plugin_basename( __FILE__ ) );
}
if ( ! defined( 'ITC_SLAWP_SECURE_LOGIN_AUTHORIZATION_PLUGIN_DIR_PATH' ) ) {
	define( 'ITC_SLAWP_SECURE_LOGIN_AUTHORIZATION_PLUGIN_DIR_PATH', plugin_dir_path( __FILE__ ) );
}
if ( ! defined( 'ITC_SLAWP_SECURE_LOGIN_AUTHORIZATION_PLUGIN_DIR_URL' ) ) {
	define( 'ITC_SLAWP_SECURE_LOGIN_AUTHORIZATION_PLUGIN_DIR_URL', plugin_dir_url( __FILE__ ) );
}

require_once ITC_SLAWP_SECURE_LOGIN_AUTHORIZATION_PLUGIN_DIR_PATH . 'includes/BaseController.php';

require_once ITC_SLAWP_SECURE_LOGIN_AUTHORIZATION_PLUGIN_DIR_PATH . 'includes/itc-rewrite-handler.php';

function itc_slawp_initiate_secure_login_authorization() {
	require_once ITC_SLAWP_SECURE_LOGIN_AUTHORIZATION_PLUGIN_DIR_PATH . 'includes/class-activator.php';
	$objActivator = new ITC_SLAWP_Secure_Login_Authorization_Activator();
	$objActivator->activate();
}

function itc_slawp_disconnect_secure_login_authorization() {
	require_once ITC_SLAWP_SECURE_LOGIN_AUTHORIZATION_PLUGIN_DIR_PATH . 'includes/class-deactivator.php';
	$objDeactivator = new ITC_SLAWP_Secure_Login_Authorization_Deactivator();
	$objDeactivator->deactivate();
}

function itc_slawp_begin_secure_login_authorization() {
	require_once ITC_SLAWP_SECURE_LOGIN_AUTHORIZATION_PLUGIN_DIR_PATH . 'includes/class-itc.php';
	$plugin = new ITC_SLAWP_Secure_Login_Authorization();
	$plugin->run();
}

register_activation_hook( __FILE__, 'itc_slawp_initiate_secure_login_authorization' );
register_deactivation_hook( __FILE__, 'itc_slawp_disconnect_secure_login_authorization' );
itc_slawp_begin_secure_login_authorization();
