<?php

if ( ! defined( 'WPINC' ) ) {
    die;
}

add_action( 'update_option_itc_slawp_secure_login_authorization', 'itc_slawp_flush_rewrite_rules_changes_secure_login_authorization_itc', 10, 2 );
add_action( 'itc_slawp_secure_login_authorization_plugin_reset_secret', 'itc_slawp_flush_rewrite_rules_changes_secure_login_authorization_itc', 10, 2 );

function itc_slawp_flush_rewrite_rules_changes_secure_login_authorization_itc( $old_value, $new_value ) {
    if ( $old_value !== $new_value ) {

        // Delete the old secret key from the database
        delete_option('itc_slawp_secure_login_authorization');

        // Add the new secret key to the database
        add_option('itc_slawp_secure_login_authorization', $new_value);

        require_once ITC_SLAWP_SECURE_LOGIN_AUTHORIZATION_PLUGIN_DIR_PATH . 'includes/class-authorization.php';

        // Instantiate the class for handling the rewrite rules
        $plugin_slawp_login_authorize = new ITC_SLAWP_Login_Authorization();
        
        // Add or update rewrite rules
        $plugin_slawp_login_authorize->add_rewrite_rules_slawp_secure_login_authorization_itc();

        // Flush rewrite rules to apply changes
        flush_rewrite_rules();
    }
}

/**
 * Add and flush rewrite rules during plugin activation.
 */
function itc_slawp_flush_secure_login_authorization_initiate() {

    require_once ITC_SLAWP_SECURE_LOGIN_AUTHORIZATION_PLUGIN_DIR_PATH . 'includes/class-authorization.php';

    // Instantiate the class for handling the rewrite rules
    $plugin_slawp_login_authorize = new ITC_SLAWP_Login_Authorization();
    
    // Add rewrite rules during activation
    $plugin_slawp_login_authorize->add_rewrite_rules_slawp_secure_login_authorization_itc();

    // Flush rewrite rules to apply changes
    flush_rewrite_rules();
}

/**
 * Flush rewrite rules 
 */
function itc_slawp_disconnect_flush_secure_login_authorization() {
    // Simply flush rewrite rules to remove custom rules
    flush_rewrite_rules();
}

// Register activation and deactivation hooks for rewrite rules.
register_activation_hook( __FILE__, 'itc_slawp_flush_secure_login_authorization_initiate' );
register_deactivation_hook( __FILE__, 'itc_slawp_disconnect_flush_secure_login_authorization' );
