<?php
if ( ! defined( 'ABSPATH' ) ) exit;
class ITC_SLAWP_Secure_Login_Authorization_Plugin_Reset_Using_URL {

    private $base_controller;

    public function __construct() {
        // Initialize the BaseController 
        $this->base_controller = new ITC_SLAWP_Secure_Login_Authorization_BaseController();
    }

    public function itc_slawp_handle_reset_url() {
        // Check if the reset key is in the query string
        if (isset($_GET['itc_reset_key'])) {
            // Unslash and sanitize the reset key
            $reset_key = sanitize_text_field(wp_unslash($_GET['itc_reset_key']));
            $stored_key = get_option('itc_slawp_secure_login_authorization_plugin_reset_secret');

            // Sanitize the _wpnonce value
            if (isset($_GET['_wpnonce'])) {
                $nonce = sanitize_text_field(wp_unslash($_GET['_wpnonce']));
            } else {
                $nonce = '';
            }

            // Check if the nonce is valid
            if ($nonce && !wp_verify_nonce($nonce, 'itc_slawp_secure_login_authorization_plugin_reset_secret')) {
                // If nonce is invalid, abort
                wp_die(
                    esc_html__('Nonce verification failed.', 'secure-login-authorization'),
                    esc_html__('Error', 'secure-login-authorization'),
                    array('response' => 403)
                );
                return;
            }

            // Validate the key
            if ($reset_key && $reset_key === $stored_key) {
                // Reset plugin settings
                $this->reset_plugin_settings();

                // Notify the user
                wp_die(
                    esc_html__('Plugin settings have been reset successfully! The Login Authorization code has also been reset.', 'secure-login-authorization'),
                    esc_html__('Success', 'secure-login-authorization'),
                    array('response' => 200)
                );
            } else {
                wp_die(
                    esc_html__('Invalid reset key.', 'secure-login-authorization'),
                    esc_html__('Error', 'secure-login-authorization'),
                    array('response' => 403)
                );
            }
        } else {
            // Allow access even if reset key is not provided (temporary for troubleshooting)
            return; // Do nothing, this avoids blocking the website
        }
    }

    // Resets the plugin settings to default
    private function reset_plugin_settings() {
        // List of plugin options to reset
        $plugin_options = array(
            'itc_slawp_secure_login_authorization_plugin_access',             // Plugin access settings
            'itc_slawp_secure_login_authorization',    // Login authorization settings
            $this->get_settings(),           // Main plugin settings
            'itc_slawp_hide_plugin',               // Hide plugin setting
            'itc_slawp_login_authorization_toggle' // Login authorization toggle setting
        );

        // Delete each option from the database except the reset secret key
        foreach ($plugin_options as $option) {
            delete_option($option);
        }

        // Reset default options if required (using the defaults from BaseController)
        $this->initialize_default_settings();
    }

    // Retrieves the settings slug 
    private function get_settings() {
        // Use the slug from BaseController
        return $this->base_controller->get_settings();
    }

    // Initialize default settings for the plugin
    private function initialize_default_settings() {
        // Get default settings from BaseController
        $default_settings = $this->base_controller->get_option_default();

        // Set the default settings 
        update_option($this->base_controller->get_settings(), $default_settings);

        // Reset the secret key for login authorization 
        if (!get_option('itc_slawp_secure_login_authorization')) {
            $new_key = wp_generate_password(32, false);
            update_option('itc_slawp_secure_login_authorization', $new_key);
        }
    }
}
