<?php
if ( ! defined( 'ABSPATH' ) ) exit;

// Include Composer's autoloader
require_once plugin_dir_path(__FILE__) . 'assets/vendor/autoload.php';

use Endroid\QrCode\Color\Color;
use Endroid\QrCode\Encoding\Encoding;
use Endroid\QrCode\ErrorCorrectionLevel\ErrorCorrectionLevelHigh;
use Endroid\QrCode\QrCode;
use Endroid\QrCode\RoundBlockSizeMode\RoundBlockSizeModeMargin;
use Endroid\QrCode\Writer\PngWriter;

class ITC_SLAWP_Secure_Login_Authorization_QR_Generator_App {

    public function __construct() {}

    public function itc_slawp_generate_qr_code_secure_login_authorization() {
        // Get the site URL and secret key
        $site_url = get_site_url();
        $secret_key = get_option('itc_slawp_secure_login_authorization', '');

        if (empty($site_url) || empty($secret_key)) {
            wp_send_json_error(['message' => 'Missing site URL or secret key.']);
            return;
        }

        try {
            // Construct the full data string for the QR code
            $data = $site_url . '?key=' . $secret_key;

            // Create the QR code
            $writer = new PngWriter();
            $qrCode = QrCode::create($data)
                ->setEncoding(new Encoding('UTF-8'))
                ->setSize(300)
                ->setMargin(10)
                ->setErrorCorrectionLevel(new ErrorCorrectionLevelHigh())
                ->setForegroundColor(new Color(0, 0, 0)) // Black foreground
                ->setBackgroundColor(new Color(255, 255, 255)); // White background

            // Generate the QR code as a PNG
            $result = $writer->write($qrCode);

            // Convert QR code to base64
            $qrImage = base64_encode($result->getString());

            // Send the base64 image back in the response
            wp_send_json_success(['qr_image' => $qrImage]);
        } catch (Exception $e) {
            // Handle any errors
            wp_send_json_error(['message' => $e->getMessage()]);
        }
    }
}
