<?php
if ( ! defined( 'ABSPATH' ) ) exit;

class ITC_SLAWP_Secure_Login_Authorization_Plugin_Access {

    public function itc_slawp_restrict_plugin_settings_page() {
        // Get the list of allowed admin user IDs from the plugin access option
        $plugin_access = get_option('itc_slawp_secure_login_authorization_plugin_access', array());

        // If no users are configured, allow all administrators by default
        if (empty($plugin_access)) {
            $admins = get_users(array('role' => 'Administrator'));
            $plugin_access = wp_list_pluck($admins, 'ID');

            // Ensure the list is stored as an array of integers
            $plugin_access = array_map('intval', $plugin_access);
        }

        // Check if the current user is allowed
        if (is_admin() && isset($_GET['page']) && $_GET['page'] === 'secure-login-authorization') {
            $current_user_id = get_current_user_id();

            // Ensure $current_user_id is an integer
            $current_user_id = intval($current_user_id);

            if (!in_array($current_user_id, $plugin_access, true)) { // Strict type checking
                wp_die(esc_html__('Sorry, you are not allowed to access this page.', 'secure-login-authorization'));
            }
        }

        // Verify nonce if form data is being processed
        if (isset($_SERVER['REQUEST_METHOD']) && $_SERVER['REQUEST_METHOD'] === 'POST') {
            if (isset($_POST['itc_slawp_secure_login_nonce'])) {
                $nonce = sanitize_text_field(wp_unslash($_POST['itc_slawp_secure_login_nonce']));

                if (!wp_verify_nonce($nonce, 'itc_secure_login_action')) {
                    wp_die(esc_html__('Invalid request. Please try again.', 'secure-login-authorization'));
                }
            }
        }
    }
}
