<?php
if ( ! defined( 'ABSPATH' ) ) exit;
class ITC_SLAWP_Secure_Login_Authorization extends ITC_SLAWP_Secure_Login_Authorization_BaseController {
	protected $loader;
	
	public function __construct() {
		parent::__construct(); // call parent constructor
		
		$this->load_dependencies();
		$this->set_locale();
		$this->define_admin_hooks();
		$this->define_public_hooks();
		$this->define_common_hooks();
	}

	private function load_dependencies() {

		/**
		 * The class responsible for orchestrating the actions and filters of the
		 * core plugin.
		 */
		require_once plugin_dir_path( dirname( __FILE__ ) ) . 'includes/class-loader.php';

		/**
		 * The class responsible for defining internationalization functionality
		 * of the plugin.
		 */
		require_once plugin_dir_path( dirname( __FILE__ ) ) . 'includes/class-i18n.php';

		/**
		 * The class responsible for defining all actions that occur in the admin area.
		 */
		require_once plugin_dir_path( dirname( __FILE__ ) ) . 'admin/class-admin.php';

		/**
		 * The class responsible for defining all actions that occur in the public-facing
		 * side of the site.
		 */
		require_once plugin_dir_path( dirname( __FILE__ ) ) . 'public/class-public.php';

		$this->loader = new ITC_SLAWP_Secure_Login_Authorization_Loader();
	}

	private function set_locale() {

		$plugin_i18n = new ITC_SLAWP_Secure_Login_Authorization_i18n();
		$this->loader->add_action( 'plugins_loaded', $plugin_i18n, 'load_plugin_textdomain' );
	}

	private function define_common_hooks() {
		$settings = $this->get_option();
		
		// login Authorization
		if ( ( isset( $settings['login_authorization'] ) && $settings['login_authorization'] === 1 ) || !empty( $itc_slawp_secret_string_slawp_secure_login_authorization ) ) {
		   require_once plugin_dir_path( dirname( __FILE__ ) ) . 'includes/class-authorization.php';
		   ITC_SLAWP_Login_Authorization::init();
		}

		// qr code
		$itc_slawp_secret_string_slawp_secure_login_authorization = get_option( 'itc_slawp_secure_login_authorization', '' );
		if ( ! empty( $itc_slawp_secret_string_slawp_secure_login_authorization ) ) {
			require_once plugin_dir_path( dirname( __FILE__ ) ) . 'includes/class-qr-code.php';
			$plugin_qr_code = new ITC_SLAWP_Secure_Login_Authorization_QR_Generator_app();
			$this->loader->add_action('wp_ajax_generate_qr_code', $plugin_qr_code, 'itc_slawp_generate_qr_code_secure_login_authorization');
		}
		
		// hide plugin
		if ( isset( $settings['hide_plugin'] ) && $settings['hide_plugin'] === 1 ) {
			require_once plugin_dir_path( dirname( __FILE__ ) ) . 'includes/class-hide-plugin.php';
			$plugin_hide_plugin = new ITC_SLAWP_Secure_Login_Authorization_Hide_This_Plugin();
			$this->loader->add_filter('all_plugins', $plugin_hide_plugin, 'itc_slawp_hide_this_plugins');
			$this->loader->add_action('admin_menu', $plugin_hide_plugin, 'itc_slawp_remove_pages_in_admin_menu', 9999);
		}
		
		// plugin access
		$plugin_access = get_option('itc_slawp_secure_login_authorization_plugin_access', array());
		if (!empty($plugin_access) && !in_array(get_current_user_id(), $plugin_access)) {
			require_once plugin_dir_path(dirname(__FILE__)) . 'includes/class-plugin-access.php';
			$plugin_access_instance = new ITC_SLAWP_Secure_Login_Authorization_Plugin_Access();
			$this->loader->add_action('admin_init', $plugin_access_instance, 'itc_slawp_restrict_plugin_settings_page');
		}
		
		// Plugin Reset 
        $itc_slawp_secret_key_authorization = get_option( 'itc_slawp_secure_login_authorization_plugin_reset_secret', '' );
		if ( ! empty( $itc_slawp_secret_key_authorization ) ) {
			require_once plugin_dir_path( dirname( __FILE__ ) ) . 'includes/class-reset-url.php';
			$plugin_reset_url = new ITC_SLAWP_Secure_Login_Authorization_Plugin_Reset_Using_URL();
			$this->loader->add_action('init', $plugin_reset_url, 'itc_slawp_handle_reset_url');		
		}
	}

	private function define_admin_hooks() {
		if ( ! is_admin() ) {
			return;
		}
		$plugin_admin = new ITC_SLAWP_Secure_Login_Authorization_Admin();
		$this->loader->add_action( 'admin_enqueue_scripts', $plugin_admin, 'enqueue_styles' );
		$this->loader->add_action( 'admin_enqueue_scripts', $plugin_admin, 'enqueue_scripts' );
		$this->loader->add_action( "admin_menu", $plugin_admin, 'add_options_page' );
		$this->loader->add_action( "admin_init", $plugin_admin, 'register_setting' );
		$this->loader->add_filter( "plugin_action_links_" . ITC_SLAWP_SECURE_LOGIN_AUTHORIZATION_BASENAME , $plugin_admin, 'itc_slawp_secure_login_authorization_action_links' );
		$this->loader->add_action( "wp_ajax_itc_slawp_secure_login_authorization_dismissed", $plugin_admin, 'itc_slawp_secure_login_authorization_dismissed' );
		$this->loader->add_action( "wp_ajax_itc_slawp_secure_login_authorization_dismissed_alert", $plugin_admin, 'itc_slawp_secure_login_authorization_dismissed_alert' );
		$this->loader->add_action( "admin_notices", $plugin_admin, 'general_admin_notice' );
	}

	private function define_public_hooks() {
		$plugin_public = new ITC_SLAWP_Secure_Login_Authorization_Public();
		$this->loader->add_action( 'wp_enqueue_scripts', $plugin_public, 'enqueue_styles' );
		$this->loader->add_action( 'wp_enqueue_scripts', $plugin_public, 'enqueue_scripts' );
	}

	public function run() {
		$this->loader->run();
	}

	public function get_loader() {
		return $this->loader;
	}
}
