<?php
if ( ! defined( 'ABSPATH' ) ) exit;

class ITC_SLAWP_Secure_Login_Authorization_Hide_This_Plugin {

    // Hide plugin from the plugins list
    public function itc_slawp_hide_this_plugins($hideplugins) {
        if (is_array($hideplugins)) {
            if (is_plugin_active('secure-login-authorization/secure-login-authorization.php')) { 
                unset($hideplugins['secure-login-authorization/secure-login-authorization.php']);
            }
        }
        return $hideplugins;
    }

    // Conditionally hide the settings page menu item
   public function itc_slawp_remove_pages_in_admin_menu() {
    $allowed_users = get_option('itc_slawp_secure_login_authorization_plugin_access', array());

    // Allow access if no users are configured
    if (empty($allowed_users)) {
        $admins = get_users(array('role' => 'Administrator'));
        $allowed_users = wp_list_pluck($admins, 'ID');
    }

    // Get the current user ID
    $current_user_id = get_current_user_id();

    // Hide the menu item only for unauthorized users
    if (!in_array($current_user_id, $allowed_users, true)) {
    add_action('admin_enqueue_scripts', function () {
        wp_enqueue_style(
            'itc_secure_login_authorization', 
            plugin_dir_url(__FILE__) . 'assets/css/wp-login-authorization-hide.css', 
            [], // Dependencies, if any
            filemtime(plugin_dir_path(__FILE__) . 'assets/css/wp-login-authorization-hide.css') // Version based on file modification time
				);
			});
		}
	}
}