<?php
if ( ! defined( 'ABSPATH' ) ) exit;
class ITC_SLAWP_Secure_Login_Authorization_Activator extends ITC_SLAWP_Secure_Login_Authorization_BaseController {
    public function __construct() {
        parent::__construct(); // Call parent constructor
    }

    public function activate() {
        // Register the module
        $this->register_Module($this->get_plugin_name(), $this->get_plugin_detail());

        // Set default values if they don't exist
        $defaultSetting = $this->get_option_default();
        if (get_option($this->get_settings()) === false) {
            add_option($this->get_settings(), $defaultSetting);
            $this->set_transient(); // Show a notice only once upon activation
        }

        // Generate and store the reset key every time the plugin is activated (overwrite existing key)
        $reset_key = wp_generate_password(20, false);  // Generate a new reset key
        update_option('itc_slawp_secure_login_authorization_plugin_reset_secret', $reset_key);  // Store it in the database

        // Build the reset URL using the generated/reset key
        $reset_url = esc_url(add_query_arg(array(
            'itc_reset_key' => $reset_key,  // Add the reset key to the URL
        ), home_url()));  // Append it to the site’s base URL

        // Ensure the login authorization key is generated if it doesn't exist
        $itc_slawp_secret_string_slawp_secure_login_authorization = get_option('itc_slawp_secure_login_authorization', '');
        if (empty($itc_slawp_secret_string_slawp_secure_login_authorization)) {
            $itc_slawp_secret_string_slawp_secure_login_authorization = wp_generate_password(32, false, false);
            update_option('itc_slawp_secure_login_authorization', $itc_slawp_secret_string_slawp_secure_login_authorization);
        }

        // Get the site URL
        $site_url = get_site_url();

        // Prepare the email content
		$admin_email = get_option('admin_email');
		$subject = __('IMPORTANT LINKS - Secure Login Authorization', 'secure-login-authorization');
		$message = __("Hello,\n\n", 'secure-login-authorization');
		$message .= __("This is a system-generated email from Secure Login Authorization Plugin. Keep this information safe:\n\n", 'secure-login-authorization');
		$message .= __('Reset URL:', 'secure-login-authorization') . " $reset_url\n\n";
		$message .= __("Login Authorization Code: If you have forgotten the Login Authorization Code, please reset the plugin and copy the code from the plugin settings dashboard.\n\n", 'secure-login-authorization');
		$message .= __("If you have hidden the plugin, you can access it by going to Settings, where you will find 'Secure Login Authorization'.\n", 'secure-login-authorization');
		$message .= __("Please note that this tab is only visible to authorized users.\n", 'secure-login-authorization');

        // Check if the PHP mail function is enabled
        if (function_exists('mail') && is_callable('mail')) {
            // Send the email to the admin
            wp_mail($admin_email, $subject, $message);
        } else {
            // Log an error or display an admin notice
            if (is_admin()) {
                add_action('admin_notices', function() {
                    echo '<div class="notice notice-error"><p><strong>Warning:</strong> The PHP <code>mail()</code> function is disabled on this server. Emails cannot be sent.</p></div>';
                });
            } 
        }
    }
}
