jQuery(document).ready(function ($) {
    const logoutTime = parseInt(wpSecureAccessITC.logoutTime, 10); // Expiry time (UNIX timestamp)
    const warningTime = logoutTime - 60; // 1 minute before expiry

    // Check if the authorization has been paused for this user
    const isPaused = parseInt(wpSecureAccessITC.isPaused, 10); // Value from localized script

    function showWarning() {
        // Ensure the notice is visible and not dismissed
        if (!$('#session-expiry-warning').length) {
            $('body').append('<div class="notice notice-warning is-dismissible" id="session-expiry-warning"><p>Your session will expire in 1 minute. Please save your work.</p></div>');
        }
    }

    function autoLogout() {
        alert('Your session has expired. You will now be logged out.');
        window.location.href = wpSecureAccessITC.logoutUrl;
    }

    function checkTime() {
        const currentTime = Math.floor(Date.now() / 1000); // Current time (UNIX timestamp)
        
        // If the login authorization is paused for this user, skip expiry logic
        if (isPaused) {
            return; // No warning or auto logout, since authorization is paused
        }

        if (currentTime >= warningTime && currentTime < logoutTime) {
            showWarning();
        } else if (currentTime >= logoutTime) {
            autoLogout();
        }
    }

    // Check time every 5 seconds
    setInterval(checkTime, 5000);

    // Event listener for "Pause Login Authorization" button click
    $('#pause-login-auth-button').on('click', function () {
        const action = $(this).data('action'); // Either 'pause' or 'continue'

        // Send AJAX request to server to update the pause state
        $.ajax({
            url: wpSecureAccessITC.ajaxUrl,
            type: 'POST',
            data: {
                action: 'toggle_login_authorization',
                state: action, // 'pause' or 'continue'
            },
            success: function (response) {
                if (response.success) {
                    // Toggle the button text based on the new state
                    if (action === 'pause') {
                        $('#pause-login-auth-button').text('Continue Login Authorization').data('action', 'continue');
                    } else {
                        $('#pause-login-auth-button').text('Pause Login Authorization').data('action', 'pause');
                    }
                    // Update the paused state for the JS logic
                    wpSecureAccessITC.isPaused = action === 'pause' ? 1 : 0;
                } else {
                    alert('Failed to update authorization state. Please try again.');
                }
            }
        });
    });
});
