<?php
if ( ! defined( 'ABSPATH' ) ) exit;
if( ! class_exists( 'ITC_SLAWP_Secure_Login_Authorization_BaseController' ) ) {
	class ITC_SLAWP_Secure_Login_Authorization_BaseController{
		private $plugin_name_parent = 'itc_slawp_secure_login_authorization_module_settings';
		private $plugin_detail;

		function __construct() {

			$this->plugin_detail = array(
				'name'		=>'itc_slawp_secure_login_authorization',
				'title'		=> esc_html__( 'Secure Login Authorization', 'secure-login-authorization' ),
				'slug'		=>'secure-login-authorization',
				'version'	=> ( defined( 'ITC_SLAWP_SECURE_LOGIN_AUTHORIZATION_VERSION' ) ) ? ITC_SLAWP_SECURE_LOGIN_AUTHORIZATION_VERSION: '1.0.0',
				'settings'	=>'itc_slawp_secure_login_authorization_settings',
			);
		}

        public function register_Module($plugin_name, $plugin_details){
            $plugins = get_option($this->plugin_name_parent);
            if ($plugins === false) {
        $plugins = [];
    }

            if($plugin_name !== "" && isset($plugins[$plugin_name])){
        $finalModuleDetails = array_merge($plugins[$plugin_name], $plugin_details);
            } else {
        $finalModuleDetails = $plugin_details;
            }
            $plugins[$plugin_name] = $finalModuleDetails;
            update_option($this->plugin_name_parent, $plugins);
        }
        
        public function unregister_Module($plugin_name){
            $plugins = get_option($this->plugin_name_parent);
            if($plugin_name!== "" && isset($plugins[$plugin_name])){
                unset($plugins[$plugin_name]);
                update_option($this->plugin_name_parent, $plugins);
            }
        }
        
        public function uninstall_Module($plugin_name){
            $this->unregister_Module($plugin_name);
            //ALSO IF WE WANT TO DEL ANY MODULE SETTINGS ADD HERE.
        }
        
        public function get_Module($plugin_name = ""){
            $plugins = get_option($this->plugin_name_parent);
            if($plugin_name!== "" && isset($plugins[$plugin_name])){
                return $plugins[$plugin_name];
            }
            return [];
        }

		public function get_plugin_detail() {
			return $this->plugin_detail;
		}

		public function get_plugin_name() {
			$detail = $this->get_plugin_detail();
			return $detail['name'];
		}

		public function get_plugin_title() {
			$detail = $this->get_plugin_detail();
			return $detail['title'];
		}
		
		public function get_plugin_slug() {
			$detail = $this->get_plugin_detail();
			return $detail['slug'];
		}

		public function get_version() {
			$detail = $this->get_plugin_detail();
			return $detail['version'];
		}
		
		public function get_settings() {
			$detail = $this->get_plugin_detail();
			return $detail['settings'];
		}


		public function get_option_default($key=""){
			$default = array(
				"hide_plugin"=>0,
				"login_authorization"=>0,
			);
			if($key!=="" && isset($default[$key])){
				$result = ($default[$key] == "1") ? 1 : 0;
				return $result;
			}
			return $default;
		}

		public function get_option($key=""){
			$defaultSettings = $this->get_option_default();
			$settings = get_option($this->get_settings(), $defaultSettings);
			if(isset($settings[$key])){
				return $settings[$key];
			}
			return $settings;
		}
		
		//This is to display msg after plugin activation.
		public function set_transient(){
			$notice_dismiss_index = $this->get_settings().'_notice_dismiss';
			set_transient( 'itc_slawp_secure_login_authorization' . $notice_dismiss_index, true, 5 ); // Prefixed transient name
		}
		public function get_transient(){
			$notice_dismiss_index = $this->get_settings().'_notice_dismiss';
			return get_transient( 'itc_slawp_secure_login_authorization' . $notice_dismiss_index );
		}
		public function remove_transient(){
			$notice_dismiss_index = $this->get_settings().'_notice_dismiss';
			delete_transient( 'itc_slawp_secure_login_authorization' . $notice_dismiss_index );
		}
		
		//This is to display msg after plugin activation.
		public function set_transient_alert(){
			$notice_dismiss_index = $this->get_settings().'_notice_dismiss_alert';
			set_transient( 'itc_slawp_secure_login_authorization' . $notice_dismiss_index, 1); // Prefixed transient name
		}
		public function get_transient_alert(){
			$notice_dismiss_index = $this->get_settings().'_notice_dismiss_alert';
			return get_transient( 'itc_slawp_secure_login_authorization' . $notice_dismiss_index );
		}
		public function remove_transient_alert(){
			$notice_dismiss_index = $this->get_settings().'_notice_dismiss_alert';
			set_transient( 'itc_slawp_secure_login_authorization' . $notice_dismiss_index, 9 ); // Prefixed transient name
			// delete_transient( 'itc_slawp_secure_login_authorization' . $notice_dismiss_index );
		}
	}
}