<?php 
if ( ! defined( 'ABSPATH' ) ) exit;
$settings_slug_sanitized = $this->get_settings();
$settings = $this->get_option() ?: []; // Ensure $settings is an array
$itc_slawp_secret_string_slawp_secure_login_authorization = get_option('itc_slawp_secure_login_authorization', ''); // Default to empty string if not set

if (empty($itc_slawp_secret_string_slawp_secure_login_authorization)) {
    $itc_slawp_secret_string_slawp_secure_login_authorization = wp_generate_password(32, false, false);
    update_option('itc_slawp_secure_login_authorization', $itc_slawp_secret_string_slawp_secure_login_authorization);
}

$site_url = get_site_url();
?>

<form action="options.php" method="post" class="options_form">
    <?php 
    // Output settings errors
    settings_errors(esc_attr($settings_slug_sanitized) . "_option_group"); 
    
    // Output nonce and hidden fields for the options group
    settings_fields(esc_attr($settings_slug_sanitized) . "_option_group"); 
    
    // Output registered sections and fields
    do_settings_sections(esc_attr($settings_slug_sanitized) . "_options_page"); 
    ?>
    
    <!-- Login Authorization Section -->
    <div class="itc_bg itc_width_xs margin-t30">
        <table class="form-table itc_table">
            <tr valign="top">
                 <th scope="row" class="menu_tbl_heading">
                    <label for="<?php echo esc_attr($settings_slug_sanitized); ?>[login_authorization]">
                        <span><?php esc_html_e('Enable Login Authorization', 'secure-login-authorization'); ?></span><br>
                        <a href="https://play.google.com/store/apps/details?id=com.ideasToCode.SecureLoginAuthorization" target="_blank"><span><em><?php esc_html_e('(Download the app', 'secure-login-authorization'); ?></em></span></a>
				<span><em><?php esc_html_e('and copy/scan the SecretKey before enabling this)', 'secure-login-authorization'); ?></em></span>
                    </label>
                </th>
                <td>
                    <label class="form-switch">
                        <input class="checkbox" type="checkbox" id="<?php echo esc_attr($settings_slug_sanitized); ?>[login_authorization]" name="<?php echo esc_attr($settings_slug_sanitized); ?>[login_authorization]" value="1" <?php checked(1, isset($settings['login_authorization']) && $settings['login_authorization'] === 1); ?> />
                        <i></i>
                    </label>
                </td>
            </tr>
        </table>
    </div>

    <!-- Secret Key Section -->
    <div class="itc_bg itc_width_xs margin-t2">
        <input type="text" id="copy-secret-key-box" value="<?php echo esc_html($itc_slawp_secret_string_slawp_secure_login_authorization); ?>" readonly class="regular-text" />
        <button type="button" class="button itc_btn_sm" onclick="copyToClipboard('copy-secret-key-box')"><?php esc_html_e('Copy', 'secure-login-authorization'); ?></button>
    </div>
	
	    <!-- QR Code Section -->
<div class="itc_bg itc_width_xs margin-t2">
    <img id="qr-code-secure-login-authorization" src="" alt="QR Code for Secure Login" style="max-width: 250px;"/>
</div>


    <!-- Hide Plugin Section -->
    <div class="itc_bg itc_width_xs margin-t10">
        <table class="form-table itc_table">
            <tr valign="top">
                <th scope="row" class="menu_tbl_heading">
                    <label for="<?php echo esc_attr($settings_slug_sanitized); ?>[hide_plugin]">
                        <span><?php esc_html_e('Hide this Plugin', 'secure-login-authorization'); ?></span><br>
                        <span><em><?php esc_html_e('(This will only remove it from the plugin list; however, to fully hide it, combine with plugin access settings so only authorized admins can view the tab under Settings.)', 'secure-login-authorization'); ?></em></span>
                    </label>
                </th>
                <td>
                    <label class="form-switch">
                        <input class="checkbox" type="checkbox" id="<?php echo esc_attr($settings_slug_sanitized); ?>[hide_plugin]" name="<?php echo esc_attr($settings_slug_sanitized); ?>[hide_plugin]" value="1" <?php checked(1, isset($settings['hide_plugin']) && $settings['hide_plugin'] === 1); ?> />
                        <i></i>
                    </label>
                </td>
            </tr>
        </table>
    </div>
    <?php 
    // Submit button
    submit_button( esc_html__('Save Changes', 'secure-login-authorization'), 'primary itc_btn_sm' ); 
    ?>
</form>
