<?php
if ( ! defined( 'ABSPATH' ) ) exit;
// Retrieve the secret key, or generate it if it doesn't exist
$itc_slawp_secret_key_authorization = get_option('itc_slawp_secure_login_authorization_plugin_reset_secret');
if (!$itc_slawp_secret_key_authorization) {
    // Generate a secret key only if it doesn't exist yet
    $itc_slawp_secret_key_authorization = wp_generate_password(20, false);
    update_option('itc_slawp_secure_login_authorization_plugin_reset_secret', $itc_slawp_secret_key_authorization);
}

// Build the reset URL using the same secret key
$reset_url = esc_url(add_query_arg(array(
    'itc_reset_key' => $itc_slawp_secret_key_authorization,
), home_url()));
?>

<h2 class="itc_title"><?php esc_html_e('Plugin Reset URL', 'secure-login-authorization'); ?></h2>
<div class="itc_bg itc_width_md">
    <p>
        <?php esc_html_e('SAVE THIS URL to reset the plugin if you\'re locked out (or if you\'ve lost the SecretKey). Paste the following URL into your browser to reset the plugin automatically (no need to log in).', 'secure-login-authorization'); ?>
    </p>

    <!-- Reset URL display -->
    <div id="reset_url_container">
        <input 
            type="text" 
            value="<?php echo esc_url($reset_url); ?>" 
            readonly 
            style="width: 85%; padding: 2px; font-size: 14px;" 
            id="reset_url" 
        />
		<button type="button" class="button itc_btn_sm" onclick="copyToClipboard('reset_url')"><?php esc_html_e('Copy', 'secure-login-authorization'); ?></button>
    </div>

    <p>
        <strong><?php esc_html_e('Important:', 'secure-login-authorization'); ?></strong><br>
        <?php esc_html_e('- A NEW LOGIN AUTHORIZATION Code will be generated each time the plugin is RESET with this URL.', 'secure-login-authorization'); ?><br>
		 <?php esc_html_e('- A NEW RESET URL will be generated each time the plugin is DEACTIVATED & ACTIVATED.', 'secure-login-authorization'); ?>
    </p>
</div>
