<?php 
if ( ! defined( 'ABSPATH' ) ) exit;
$plugin_access = get_option( 'itc_slawp_secure_login_authorization_plugin_access', array() );
?>
<h2 class="itc_title"><?php esc_html_e( 'Select admins to access settings.', 'secure-login-authorization' ); ?></h2>
<em><?php esc_html_e('If all toggles are off, everyone can access.', 'secure-login-authorization'); ?></em> 
<p></p>
<form action="options.php" method="post" class="options_form">
    <?php 
    // Security and option group
    settings_fields( 'itc_slawp_secure_login_authorization_plugin_access_group' ); 
    do_settings_sections( 'itc_slawp_secure_login_authorization_plugin_access_group' );
    ?>
    <div class="itc_bg itc_width_xs margin-t5">
        <table class="form-table itc_table">
            <?php 
            // Get all administrator users
            $admins = get_users( array( 'role' => 'Administrator' ) );
            $selected_users = is_array( $plugin_access ) ? $plugin_access : array();

            foreach ( $admins as $admin ) : 
            ?>
                <tr valign="top">
                    <th scope="row" class="menu_tbl_heading">
                        <label for="admin_<?php echo esc_attr( $admin->ID ); ?>">
                            <?php echo esc_html( $admin->display_name ); ?>
                        </label>
                    </th>
                    <td>
                        <label class="form-switch">
                            <input class="checkbox" type="checkbox" 
                                   id="admin_<?php echo esc_attr( $admin->ID ); ?>" 
                                   name="itc_slawp_secure_login_authorization_plugin_access[]" 
                                   value="<?php echo esc_attr( $admin->ID ); ?>" 
                                   <?php checked( in_array( $admin->ID, $selected_users ) ); ?> />
                            <i></i>
                        </label>
                    </td>
                </tr>
            <?php endforeach; ?>
        </table>
    </div>
    <?php 
    submit_button( esc_html__( 'Save Changes', 'secure-login-authorization' ), 'primary itc_btn_sm' );
    ?>
</form>
