function copyToClipboard(inputId) {
    const copyText = document.getElementById(inputId);
    copyText.select();
    copyText.setSelectionRange(0, 99999); // For mobile devices
    document.execCommand("copy");
    alert("Copied to clipboard!");
}

jQuery(document).ready(function($) {
    // Send AJAX request to generate the QR code
    $.ajax({
        url: ITC_QR_Code.ajaxurl, // Use the localized variable
        type: 'POST',
        data: {
            action: 'generate_qr_code',
        },
        success: function(response) {
            if (response.success) {
                // Set the QR code image source
                $('#qr-code-secure-login-authorization').attr('src', 'data:image/png;base64,' + response.data.qr_image);
            } else {
                alert('Failed to generate QR code: ' + (response.data.message || 'Unknown error'));
            }
        },
        error: function() {
            alert('An error occurred while generating the QR code.');
        }
    });
});
