<?php
if ( ! defined( 'ABSPATH' ) ) exit;
if ( ! is_admin() ) {
    return;
}

class ITC_SLAWP_Secure_Login_Authorization_Admin extends ITC_SLAWP_Secure_Login_Authorization_BaseController {

    public function __construct() {
        parent::__construct();

        add_action( 'admin_notices', array( $this, 'general_admin_notice' ) );
    }
	
    public function enqueue_styles() {
		wp_enqueue_style( 
			'itc-secure-login-authorization-admin-css', plugin_dir_url( __FILE__ ) . 'css/itc-secure-login-authorization-admin.css', array(), filemtime( plugin_dir_path( __FILE__ ) . 'css/itc-secure-login-authorization-admin.css' ), 'all' ); 
	}


	public function enqueue_scripts() {
		// Enqueue the main admin JS
		wp_enqueue_script(
			'itc-secure-login-authorization-admin-js',
			plugin_dir_url( __FILE__ ) . 'js/itc-secure-login-authorization-admin.js',
			array( 'jquery' ),
			filemtime( plugin_dir_path( __FILE__ ) . 'js/itc-secure-login-authorization-admin.js' ),
			true // Load in the footer
		);

		// Localize scripts with admin-ajax URL
		wp_localize_script(
			'itc-secure-login-authorization-admin-js',
			'ITC_QR_Code',
			array(
				'ajaxurl' => admin_url( 'admin-ajax.php' ),
			)
		);
	}

	public function itc_slawp_secure_login_authorization_action_links( $links ) {
		$plugin_slug_name = $this->get_plugin_slug();
		$subpage = "";
		$links2 = '<a href="' . esc_url( menu_page_url( $plugin_slug_name, false ) . $subpage ) . '">' . esc_html__( 'Settings', 'secure-login-authorization' ) . '</a>';
		array_unshift( $links, $links2 );
		return $links;
	}

		public function add_options_page() {
				global $admin_page_hooks;
				$plugin_slug_name = $this->get_plugin_slug();
				$plugin_title = $this->get_plugin_title();

				if ( ! isset( $admin_page_hooks[$plugin_slug_name] ) ) {
					// Add the options page
					add_options_page(
					esc_html( $plugin_title ),
					esc_html( $plugin_title ),  
						'manage_options',                       
						$plugin_slug_name,                      
						array( $this, 'itc_slawp_secure_login_authorization_option_page' ) 
					);
				}
			}

    public function itc_slawp_secure_login_authorization_option_page() {
        include_once 'partials/admin-display.php';
    }

    public function register_setting() {
        $setting_slug = $this->get_settings();
        register_setting( $setting_slug . "_option_group",  $setting_slug, 
            array(
                'sanitize_callback' => array( $this, 'form_submit_sanitize' )
            )
        );
		
		// Register the SecretKey for pairing
		register_setting( 'itc_slawp_secure_login_authorization_group', 'itc_slawp_secure_login_authorization', array(
			'sanitize_callback' => array( $this, 'sanitize_itc_slawp_secret_string_slawp_secure_login_authorization' ),
		));
		
		// Register settings for plugin access
		 register_setting( 'itc_slawp_secure_login_authorization_plugin_access_group', 'itc_slawp_secure_login_authorization_plugin_access', array(
        'sanitize_callback' => array( $this, 'sanitize_plugin_access_slawp_login_authorization_itc' ),
		));
		// Register the reset secret key setting
		register_setting( 'itc_slawp_secure_login_authorization_plugin_reset_group', 'itc_slawp_secure_login_authorization_plugin_reset_secret', array(
			'sanitize_callback' => array( $this, 'sanitize_itc_slawp_secret_string_slawp_secure_login_authorization' ),
		));
}

    public function form_submit_sanitize( $settings ) {
        $finalSettings = $this->get_option_default();
		$finalSettings['login_authorization'] = $this->form_submit_sanitize_bool( $settings, 'login_authorization' );
        $finalSettings['hide_plugin'] = $this->form_submit_sanitize_bool( $settings, 'hide_plugin' );
        $setting_slug = $this->get_settings();

        // Only add the settings error if it hasn't been added already
        if ( ! get_option( $setting_slug ) ) {
            add_settings_error(
                $setting_slug . "_option_group",
                $setting_slug . "_option_name",
                "Setting successfully updated.",
                "updated"
            );
        }

        return $finalSettings;
    }

    private function form_submit_sanitize_bool( $settings, $key ) { 
        return isset( $settings[$key] ) && $settings[$key] == "1" ? 1 : 0;
    }
	
	// Sanitize the admin secret_string input and reset url
    public function sanitize_itc_slawp_secret_string_slawp_secure_login_authorization( $itc_slawp_secret_string_slawp_secure_login_authorization ) {
        return sanitize_text_field( $itc_slawp_secret_string_slawp_secure_login_authorization );
    }
	
	// Sanitize input for plugin access
	public function sanitize_plugin_access_slawp_login_authorization_itc( $plugin_access ) {
    if ( ! is_array( $plugin_access ) ) {
        return array();
    }
    return array_map( 'intval', $plugin_access ); 
}


    public function general_admin_notice() {
        // Removed the notice 
    }
}