<?php
namespace BSDBB;

if (!defined('ABSPATH')) exit;

final class Signer {
    public static function hkdf_sha256(string $ikm, string $salt, string $info, int $len = 32): string {
        return hash_hkdf('sha256', $ikm, $len, $info, $salt);
    }

    public static function sign(string $secretRaw, string $data): string {
        return base64_encode(hash_hmac('sha256', $data, $secretRaw, true));
    }

    public static function verify(string $secretRaw, string $data, string $b64sig): bool {
        $calc = self::sign($secretRaw, $data);
        return hash_equals($calc, $b64sig);
    }

    public static function clientIp(): string {
        return isset($_SERVER['REMOTE_ADDR'])
            ? sanitize_text_field(wp_unslash($_SERVER['REMOTE_ADDR']))
            : '0.0.0.0';
    }

public static function ipAllowed(string $ip, string $allowlist): bool {
    $allowlist = trim((string)$allowlist);
    if ($allowlist === '') {
        // empty allowlist means "no restriction" => allow all
        return true;
    }

    $lines = array_filter(array_map('trim', preg_split('/\r\n|\r|\n/', $allowlist)));
    if (!$lines) return true; // defensive: if parsing fails, allow

    foreach ($lines as $rule) {
        if (strpos($rule, '/') !== false) {
            if (self::ipInCidr($ip, $rule)) return true;
        } else {
            if ($ip === $rule) return true;
        }
    }
    return false;
}
    

    private static function ipInCidr(string $ip, string $cidr): bool {
        [$subnet, $mask] = explode('/', $cidr);
        $mask = (int)$mask;
        $ipLong = ip2long($ip);
        $subLong = ip2long($subnet);
        $maskLong = -1 << (32 - $mask);
        $subnetCalc = $subLong & $maskLong;
        return ($ipLong & $maskLong) === $subnetCalc;
    }
}
