<?php
namespace BSDBB;

if (!defined('ABSPATH')) exit;

final class NonceStore {
public static function seen(string $nonce, int $ttl): bool {
    $key = 'bsdbb_nonce_'.hash('sha256', $nonce);
    if (get_transient($key)) return true;
    set_transient($key, 1, $ttl);
    return false;
}
    
    public static function rateCheck(int $maxPer5): bool {
        $key = 'bsdbb_rate_'.floor(time()/300);
        $count = (int)get_transient($key);
        if ($count >= $maxPer5) return false;
        set_transient($key, $count+1, 310);
        return true;
    }
}
