<?php
namespace BSDBB;

if (!defined('ABSPATH')) exit;

require_once __DIR__ . '/Settings.php';
require_once __DIR__ . '/Signer.php';
require_once __DIR__ . '/NonceStore.php';
require_once __DIR__ . '/Exporter.php';
require_once __DIR__ . '/Rest.php';

final class Bootstrap {
    public static function init(): void {
        add_action('admin_menu', [self::class, 'registerAdminMenu']);
        add_action('init', [self::class, 'ensureTmpDir']);

        Settings::init();
        Rest::init();
    }

    public static function registerAdminMenu(): void {
        $icon_url    = defined('BSDBB_URL') ? BSDBB_URL . 'assets/bervice_logo.svg' : '';
        $parent_slug = 'bsdbb-settings';

        add_menu_page(
            __('DB Bridge For Bervice', 'secure-db-bridge-for-bervice'),
            __('Bridge For Bervice', 'secure-db-bridge-for-bervice'),
            'manage_options',
            $parent_slug,
            [Settings::class, 'page'],
            $icon_url,
            60
        );
    }

public static function ensureTmpDir(): void {
    require_once ABSPATH . 'wp-admin/includes/file.php';
    WP_Filesystem();
    global $wp_filesystem;

    $up  = wp_upload_dir();
    $dir = trailingslashit($up['basedir']) . 'bervice-db-bridge/tmp/';

    if (!$wp_filesystem->is_dir($dir)) {
        $wp_filesystem->mkdir($dir);
    }

    // index.html
    if (!$wp_filesystem->exists($dir . 'index.html')) {
        $wp_filesystem->put_contents($dir . 'index.html', '', FS_CHMOD_FILE);
    }

    // .htaccess for tmp dir
    $htaccess_content = "Require all denied\n";
    if (!$wp_filesystem->exists($dir . '.htaccess')) {
        $wp_filesystem->put_contents($dir . '.htaccess', $htaccess_content, FS_CHMOD_FILE);
    }

    // .htaccess for parent dir
    $parent = dirname(rtrim($dir, '/')) . '/';
    if ($wp_filesystem->is_dir($parent) && !$wp_filesystem->exists($parent . '.htaccess')) {
        $wp_filesystem->put_contents($parent . '.htaccess', $htaccess_content, FS_CHMOD_FILE);
    }
}
}

Bootstrap::init();