<?php

/**
 * The Template for displaying search field in Filters widget.
 *
 * This template can be overridden by copying it to yourtheme/filters/search.php
 *
 * $set - array, with the SFS Set parameters
 * $filter - array, with the Filter parameters
 * $url_manager - object, of the UrlManager PHP class
 * $terms - array, with objects of all filter terms except excluded
 *
 * @see https://www.searchfiltersort.com/
 */

if ( ! defined('ABSPATH') ) {
    exit;
}
// $value = isset( $_GET[''] ) ?
$placeholder     = isset( $set['search_field_placeholder']['value'] ) ? esc_html( $set['search_field_placeholder']['value'] ) : esc_html__('Search ...', 'searchfiltersort');
$label           = isset( $set['search_field_label']['value'] ) ? esc_html( $set['search_field_label']['value'] ) : esc_html__('Search', 'searchfiltersort');
$search          = isset( $_GET['srch'] ) ? filter_input( INPUT_GET, 'srch', FILTER_SANITIZE_SPECIAL_CHARS ) : '';
$search_id       = isset( $set['ID'] ) ? esc_html( $set['ID'] .'s' ) : '0s';
$section_classes = 'sfswp-filters-section sfswp-filters-section-'.$search_id.' sfswp-filter-layout-search-field';
if ( $search !== '' ){
    $section_classes .= ' sfswp-search-active';
}

$cancel_url      = $url_manager->getTermUrl( '', '', '', '', [ 'srch'=> true ] );
?>
<div class="<?php echo $section_classes; ?>" data-fid="<?php echo $search_id; ?>">
    <?php if ( $label !== '' ) {
        sfs_filter_header( array( 'label' => $label, 'collapse' => 'no', 'values' => [], 'tooltip' => false ), [] );
    } ?>
<form action="<?php echo esc_url( $url_manager->getFormActionOrFullPageUrl() ); ?>" role="search" method="GET" class="sfswp-filter-search-form"><div class="sfswp-search-field-wrapper sfswp-search-field-wrapper-<?php echo $search_id; ?>"><span class="sfswp-search-icon"></span><label for="srch" class="screen-reader-text"><?php esc_html_e( 'Search', 'searchfiltersort' ); ?></label><input type="text" class="sfswp-search-field" placeholder="<?php echo $placeholder; ?>" value="<?php echo $search; ?>" name="srch"><span class="sfswp-search-clear-icon-wrapper"><a class="sfswp-search-clear-icon" href="<?php echo esc_url( $cancel_url ); ?>" title="<?php esc_html_e('Clear search', 'searchfiltersort' ) ?>">&#215;</a></span>
                <?php
                sfs_query_string_form_fields(
                    sfs_get_query_string_parameters(),
                    ['srch']
                );
            ?></div></form></div>