<?php
/**
 * The Template for displaying Filters found posts number.
 *
 * This template can be overridden by copying it to yourtheme/filters/posts-found.php.
 *
 * $posts_found - int|NULL, posts found number
 * $singular_label - string label for single found post
 * $plural_label - string label for multiple found posts
 *
 * @see https://www.searchfiltersort.com/
 */

if ( ! defined('ABSPATH') ) {
    exit;
}

?>
<div class="sfswp-posts-found" data-found="<?php echo esc_attr( $posts_found_count ); ?>">
<p><?php
    if( $posts_found_count !== NULL ) {
        $class = ( $posts_found_count > 1 ) ? 'sfswp-posts-found-number sfswp-plural' : 'sfswp-posts-found-number';
        $label = ( $posts_found_count > 1 ) ? $plural_label : $singular_label;

        echo wp_kses(
            sprintf( _n(
                '<span class="%s">%d</span> %s found',
                '<span class="%s">%d</span> %s found',
                $posts_found_count,
                'searchfiltersort'
            ), $class, $posts_found_count, $label ),
            array(
                'span' => array('class' => true)
            )
        );

    }else{
        echo '&nbsp;';
    }
?></p>
</div>