<?php
/**
 * The Template for displaying ordering dropdown.
 *
 * This template can be overridden by copying it to yourtheme/filters/orderby.php.
 *
 * @param string $action Form action URL
 * @param string $selected_orderby Currently selected value.
 * @param array $titles Possible titles.
 * @param array $orderbies Possible orderbies.
 * @param array $orders Possible orders.
 * @param array $meta_keys Possible meta keys.
 *
 * @see https://www.searchfiltersort.com/
 * @since 1.2.6
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}
// @todo security and XSS esc_attr, sanitize attr
// @todo mark selected value
?>
<?php if( isset( $orderbies ) && ! empty( $orderbies ) ) : ?>
<form action="<?php echo esc_url( remove_query_arg( ['ordr','orderby', 'product_orderby'], $action ) ); ?>" class="sfswp-sorting-form" method="GET">
    <?php
        // 3rd party $_GET parameters
        sfs_query_string_form_fields(
            sfs_get_query_string_parameters(),
            ['ordr', 'orderby', 'product_orderby'] // Ignore these params
        );
    ?>

    <select name="ordr" class="sfswp-orderby-select" aria-label="sfswp-orderby-select">
        <?php
            foreach( $orderbies as $i => $order_by_value ) :
                $title        = isset( $titles[$i] ) ? $titles[$i] : '';
                $option_value = sfs_sorting_option_value( $order_by_value, $meta_keys, $orders, $i );
            ?>
            <option value="<?php echo esc_attr( $option_value ); ?>" <?php selected( $selected_orderby, $option_value ); ?>><?php echo esc_html( $title ); ?></option>
        <?php endforeach; ?>
    </select>
</form>
<div class="sfswp-after-sorting-form"></div>
<?php endif; ?>