<?php
/**
 * The Template for displaying filter labels.
 *
 * This template can be overridden by copying it to yourtheme/filters/labels.php.
 *
 * $set - array, with the SFS Set parameters
 * $filter - array, with the Filter parameters
 * $url_manager - object, of the UrlManager PHP class
 * $terms - array, with objects of all filter terms except excluded
 *
 * @see https://www.searchfiltersort.com/
 */

if ( ! defined('ABSPATH') ) {
    exit;
}

$args = [
    'hide' => $view_args['ask_to_select_parent']
];

$is_brand = ( in_array( $filter['e_name'], sfs_brand_filter_entities() ) );

if ( $is_brand ){
    $image_meta_key = 'image';
    if ( $filter['e_name'] === 'pwb-brand' ) {
        $image_meta_key = 'pwb_brand_image';
    } else if ( in_array( $filter['e_name'], ['yith_product_brand', 'product_brand'] ) ) {
        $image_meta_key = 'thumbnail_id';
    }
}

?>
<div class="<?php echo sfs_filter_class( $filter, [], $terms, $args ); // Already escaped ?>" data-fid="<?php echo esc_attr( $filter['ID'] ); ?>"><?php
    sfs_filter_header( $filter, $terms ); // Safe, escaped
    ?><div class="<?php echo esc_attr( sfs_filter_content_class( $filter ) ); ?>">
        <?php sfs_filter_search_field( $filter, $view_args, $terms ); ?>
        <ul class="sfswp-filters-ul-list sfswp-filters-labels sfswp-filters-list-<?php echo esc_attr( $filter['ID'] ); ?>">
            <?php if( ! empty( $terms ) || $view_args['ask_to_select_parent'] ):
                if( $view_args['ask_to_select_parent'] !== false ) { ?>
                    <li><?php echo esc_html( $view_args['ask_to_select_parent'] ); ?></li>
                <?php } else {
                    foreach ( $terms as $id => $term_object ){
                        $disabled       = 0;
                        $checked        = ( in_array( $term_object->slug, $filter['values'] ) ) ? 1 : 0;
                        $image_class    = '';

                        if( isset( $term_object->wp_queried ) && $term_object->wp_queried ){
                            $checked    = 1;
                            $disabled   = 1;
                        }

                        $active_class    = $checked ? ' sfswp-term-selected' : '';
                        $disabled_class  = $disabled ? ' sfswp-term-disabled' : '';
                        $link            = $url_manager->getTermUrl( $term_object->slug, $filter['e_name'], $filter['entity'] );
                        $link_attributes = 'href="'.esc_url($link).'"';
                        $link_attributes .= ' class="sfswp-filter-link"';

                        if ( $is_brand ) {
                            $image_class = '';
                            if ( get_term_meta( $term_object->term_id, $image_meta_key, true ) ){
                                $image_class = ' sfswp-term-has-image';
                            }
                        }

                        $is_rating = false;
                        if( mb_strpos( $term_object->slug, 'rated-' ) !== false) $is_rating = true;

                    ?>
                        <li class="sfswp-label-item sfswp-term-item<?php echo esc_attr( $active_class ); ?><?php echo esc_attr( $disabled_class ); ?><?php echo esc_attr( $image_class ); ?> sfswp-term-count-<?php echo esc_attr( $term_object->cross_count ); ?> sfswp-term-id-<?php echo esc_attr( $id ); ?>" id="<?php sfs_term_id('term', $filter, $id ); ?>">
                            <div class="sfswp-term-item-content-wrapper">
                                <input class="sfswp-label-input" <?php checked( 1, $checked ); disabled( 1, $disabled ); ?> type="checkbox" data-sfswp-link="<?php echo esc_url( $link ); ?>" id="<?php sfs_term_id('checkbox', $filter, $id); ?>" /><label for="<?php sfs_term_id('checkbox', $filter, $id); ?>"><span class="sfswp-filter-label-wrapper<?php echo ($is_rating) ? ' sfswp-filter-label-stars-wrapper' : ''; ?>"><?php
                                /**
                                 * Allow developers to change filter terms html
                                 */
                                echo apply_filters( 'sfswp_filters_label_term_html', '<a '.$link_attributes.'>'.$term_object->name.'</a>', $link_attributes, $term_object, $filter );

                                ?><?php sfs_filter_count( $term_object, $set['show_count']['value'] ); // Safe, escaped?></span></label>
                            </div>
                        </li>
                    <?php } /* end foreach */ ?>
                <?php } /* end if ask to select parent */ ?>
            <?php  else:
                sfs_filter_no_terms_message();
            endif;
?>      </ul>
        <?php sfs_filter_more_less( $filter ); ?>
    </div>
</div>