<?php
/**
 * The Template for displaying Filters opening/closing button.
 *
 * This template can be overridden by copying it to yourtheme/filters/filters-button.php.
 *
 * $sfswp_found_posts - int|NULL, found posts number
 *
 * @see https://www.searchfiltersort.com/
 */

if ( ! defined('ABSPATH') ) {
    exit;
}

?>
<div class="sfswp-filters-open-button-container sfswp-open-button-<?php echo esc_attr( $set_id ); ?>">
    <a class="<?php echo esc_attr( $class ); ?>" href="javascript:void(0);" data-wid="<?php echo esc_attr( $set_id ); ?>"><span class="sfswp-button-inner"><?php
            // Button icon
            sfs_get_icon_html();

            ?><span class="sfswp-filters-button-text"><?php

            if( $sfswp_found_posts !== NULL ){
                esc_html_e( sprintf( __('Filtered %s', 'searchfiltersort'), '('.$sfswp_found_posts.')' ) );
            } else {
                esc_html_e('Filters', 'searchfiltersort');
            }

            ?></span></span></a>
</div>