<?php
/**
 * The Template for displaying filter dropdown.
 *
 * This template can be overridden by copying it to yourtheme/filters/dropdown.php.
 *
 * $set - array, with the SFS Set parameters
 * $filter - array, with the Filter parameters
 * $url_manager - object, of the UrlManager PHP class
 * $terms - array, with objects of all filter terms except excluded
 * $noSelectUrl - string, URL for default option without selected term
 *
 * @see https://www.searchfiltersort.com/
 */

if ( ! defined('ABSPATH') ) {
    exit;
}

$noSelectUrl    = ( empty( $filter['values'] ) ) ? $url_manager->getResetUrl() : $url_manager->getTermUrl( reset( $filter['values'] ), $filter['e_name'], $filter['entity'] );
$show_term_name = true;
$is_swatch      = false;
$is_brand       = ( in_array( $filter['e_name'], sfs_brand_filter_entities() ) );
$use_select2    = false;
$data_default   = '';
$preload_html   = '';
$data_color     = '';

if ( sfs_get_experimental_option( 'select2_dropdowns' ) === 'on' ){
    $use_select2 = true;
}

if ( sfs_get_experimental_option('use_color_swatches') === 'on' ) {
    $swatch_taxes   = sfs_get_experimental_option( 'color_swatches_taxonomies', [] );
    $is_swatch      = ( in_array( $filter['e_name'], $swatch_taxes ) );
}

if ( $is_brand && ! $is_swatch ) {
    $data_default = ' data-brand='.SFS_PLUGIN_DIR_URL.'assets/img/no-image.png';
}

if ( $is_swatch ){
    $data_default = ' data-image='.SFS_PLUGIN_DIR_URL.'assets/img/no-image.png';
}

?>
<div class="<?php echo sfs_filter_class( $filter ); // Already escaped ?>" data-fid="<?php echo esc_attr( $filter['ID'] ); ?>">
    <?php sfs_filter_header( $filter, $terms ); // Safe, escaped ?>
    <div class="<?php echo esc_attr( sfs_filter_content_class( $filter ) ); ?>">
        <?php if( ! empty( $terms ) || $view_args['ask_to_select_parent'] ): ?>
            <select id="sfswp-<?php echo esc_attr( $filter['entity'] ); ?>-<?php echo esc_attr( $filter['e_name'] ); ?>-<?php echo esc_attr( $filter['ID'] ); ?>"
                    aria-label="sfswp-<?php echo esc_attr( $filter['entity'] ); ?>-<?php echo esc_attr( $filter['e_name'] ); ?>-<?php echo esc_attr( $filter['ID'] ); ?>"
                    class="sfswp-filters-widget-select">
                <?php if( $view_args['ask_to_select_parent'] !== false ) : ?>
                    <option class="sfswp-dropdown-default" value="0" data-sfswp-link="<?php echo esc_attr( $noSelectUrl ); ?>" id="sfswp-option-<?php echo esc_attr( $filter['entity'] ); ?>-<?php echo esc_attr( $filter['e_name'] ); ?>-0"><?php
                    echo esc_html( $view_args['ask_to_select_parent'] );
                    ?></option>
                <?php else: ?>
                    <option<?php echo esc_html( $data_default ); ?> class="sfswp-dropdown-default" value="0" data-sfswp-link="<?php echo esc_attr( $noSelectUrl ); ?>" id="sfswp-option-<?php echo esc_attr( $filter['entity'] ); ?>-<?php echo esc_attr( $filter['e_name'] ); ?>-0"><?php
                        echo esc_html( sfs_dropdown_default_option( $filter ) );
                    ?></option>
                    <?php

                    foreach ( $terms as $id => $term_object ) {
                        $disabled          = 0;
                        $data_image        = '';
                        $selected          = ( in_array( $term_object->slug, $filter['values'] ) ) ? 1 : 0;
                        $term_hidden_class = '';
                        $data_count        = '';
                        $data_rating       = '';

                        if( isset( $term_object->wp_queried ) && $term_object->wp_queried ){
                            $disabled   = 1;
                        }

                        if ( $is_brand && ! $is_swatch ) {
                            $src = sfs_get_term_brand_image( $term_object->term_id, $filter );
                            if ( $src ) {
                                $data_image = ' data-brand=' . $src . '';
                                $preload_html .= '<img class="sfswp-preload-img" src='. $src .' />'."\r\n";
                            }

                            if ( $filter['show_term_names'] === 'no' ) {
                                $term_hidden_class = ' sfswp-hidden-term-name';
                            }
                        }

                        if ( $is_swatch ) {
                            $src = sfs_get_term_swatch_image( $term_object->term_id, $filter );

                            if ( $src ) {
                                $data_image = ' data-image=' . $src . '';
                                $preload_html .= '<img class="sfswp-preload-img" src='. $src .' />'."\r\n";
                            } else {
                                $maybe_color = sfs_get_term_swatch_color( $term_object->term_id, $filter );
                                if ( $maybe_color ) {
                                    $data_color = ' data-color=' . $maybe_color . '';
                                } else {
                                    $data_color = ' data-color=none';
                                }
                            }

                            if ( $filter['show_term_names'] === 'no' ) {
                                $term_hidden_class = ' sfswp-hidden-term-name';
                            }
                        }

                        if( $set['show_count']['value'] === 'yes' && $use_select2 ) {
                            $data_count        = ' data-count=' . $term_object->cross_count;
                        }

                        $rating = 0;
                        if( mb_strpos( $term_object->slug, 'rated-' ) !== false){
                            $pieces = explode("-", $term_object->slug);
                            $rating = isset( $pieces[1] ) ? $pieces[1] : 0;
                            $data_rating = ' data-star-rating=' . $rating;
                        }

                        ?>
                        <option<?php echo esc_html( $data_image ); echo esc_html( $data_color ); echo esc_html( $data_count ); echo esc_html( $data_rating );?> class="sfswp-term-count-<?php echo esc_attr( $term_object->cross_count ); ?> sfswp-term-id-<?php echo esc_attr($term_object->term_id); echo esc_attr( $term_hidden_class ); ?>" value="<?php echo esc_attr( $term_object->term_id ); ?>" <?php selected( 1, $selected ); ?> <?php disabled( 1, $disabled ); ?> data-sfswp-link="<?php echo esc_attr( $url_manager->getTermUrl( $term_object->slug, $filter['e_name'], $filter['entity'] ) ); ?>" id="sfswp-option-<?php echo esc_attr( $filter['entity'] ); ?>-<?php echo esc_attr($filter['e_name']); ?>-<?php echo esc_attr( $id ); ?>">
                            <?php
                            if ($rating > 0){
                                if($use_select2){
                                    $rating_html = '';
                                    $i = 1;
                                    $label_star = '<span class="sfs-star-label %s">' . sfs_rating_star() . '</span>';
                                    while($i <=5){
                                        $star_class = '';
                                        if($i <= $rating){
                                            $star_class = 'sfs-star-label-hover';
                                        }
                                        $rating_html .= sprintf($label_star, $star_class);
                                        $i++;
                                    }
                                    echo $rating_html;
                                }else{
                                    echo sprintf(
                                        _n('%d star', '%d stars', $rating, 'searchfiltersort'),
                                        $rating
                                    );
                                }
                            }else{
                                echo esc_html( $term_object->name );
                            }

                            if( $set['show_count']['value'] === 'yes' && ! $use_select2 ) {
                               echo esc_html( ' ('.$term_object->cross_count.')' );
                            }
                        ?></option>
                    <?php } ?><!-- end foreach -->
                <?php endif; ?>
            </select>
            <?php echo $preload_html; ?>
        <?php else:
            sfs_filter_no_terms_message( 'p' );
        endif; ?>
    </div>
</div>